minetest.log("action", "[mcl_backpack] loading...")

local C = minetest.colorize
local S = minetest.get_translator(minetest.get_current_modname())

local string = string

anticheat = true

minetest.register_on_joinplayer(function(player)
	local inv = player:get_inventory()
	inv:set_size("backpack", 81) -- 9*9
end)

--[[
TODO: separate properly the hotbar from the other inventory slots
TODO: use the exact mcl2 values for spacing/pading/color
]]

if minetest.get_modpath("industrialtest") ~= nil then
   titanium_block = "industrialtest:machine_block"
   titanium_ingot = "industrialtest:refined_iron_ingot"
   paladium_block = "industrialtest:advanced_machine_block"
   paladium_ingot = "industrialtest:carbon_plate"
else
   titanium_block = "mcl_core:goldblock"
   titanium_ingot = "mcl_core:gold_ingot"
   paladium_block = "mcl_core:diamondblock"
   paladium_ingot = "mcl_core:diamond"

end


mcl_backpack = {}
mcl_backpack.form = {}
mcl_backpack.form.amethyst = table.concat({
	"formspec_version[4]",
	"size[12,8]",
	mcl_formspec.get_itemslot_bg_v4(0.5, 1, 9, 1),
	"list[current_player;backpack;0.5,1;9,1;]", --9 slots
	mcl_formspec.get_itemslot_bg_v4(0.5, 3, 9, 4),
	"list[current_player;main;0.5,3;9,4;]",
	"listring[]",
	"label[0.5,0.5;"..C("#313131", S("Backpack")).."]",
	"label[0.5,2.5;"..C("#313131", S("Inventory")).."]",
})

mcl_backpack.form.titanium = table.concat({
	"formspec_version[4]",
	"size[12,10.5]",
	mcl_formspec.get_itemslot_bg_v4(0.5, 1, 9, 3),
	"list[current_player;backpack;0.5,1;9,3;]", --27 slots
	mcl_formspec.get_itemslot_bg_v4(0.5, 5.5, 9, 4),
	"list[current_player;main;0.5,5.5;9,4;]",
	"listring[]",
	"label[0.5,0.5;"..C("#313131", S("Backpack")).."]",
	"label[0.5,5;"..C("#313131", S("Inventory")).."]",
})

mcl_backpack.form.paladium = table.concat({
	"formspec_version[4]",
	"size[12,14.5]",
	mcl_formspec.get_itemslot_bg_v4(0.5, 1, 9, 6),
	"list[current_player;backpack;0.5,1;9,6;]", --56 slots
	mcl_formspec.get_itemslot_bg_v4(0.5, 9.5, 9, 4),
	"list[current_player;main;0.5,9.5;9,4;]",
	"listring[]",
	"label[0.5,0.5;"..C("#313131", S("Backpack")).."]",
	"label[0.5,9;"..C("#313131", S("Inventory")).."]",
})

mcl_backpack.form.endium = table.concat({
	"formspec_version[4]",
	"size[12,18]",
	mcl_formspec.get_itemslot_bg_v4(0.5, 1, 9, 9),
	"list[current_player;backpack;0.5,1;9,9;]", --81 slots
	mcl_formspec.get_itemslot_bg_v4(0.5, 13, 9, 4),
	"list[current_player;main;0.5,13;9,4;]",
	"listring[]",
	"label[0.5,0.5;"..C("#313131", S("Backpack")).."]",
	"label[0.5,12.5;"..C("#313131", S("Inventory")).."]",
})

local backpack_widths = {
	["mcl_backpack:amethyste_backpack"] = 9,
	["mcl_backpack:titanium_backpack"] = 27,
	["mcl_backpack:paladium_backpack"] = 56,
	["mcl_backpack:endium_backpack"] = 81,
}

--Disallow accessing to inventory if player hasn't the right backpack to avoid cheating

--You can test with anticheat disabled and the official palamod dragonfire test mod
--https://github.com/minetest-palamod/palamod-test-dragonfire

if anticheat then
	local cheat_log = "[mcl_backpack] Player [%s] tried to interact with backpack inventory without using a backpack!"

	minetest.register_allow_player_inventory_action(function(player, action, inventory, inventory_info)
		if action == "move" or action == "take" then
			if inventory_info.from_list == "backpack" then
				local backpack = backpack_widths[player:get_wielded_item():get_name()]
				if not backpack or inventory_info.from_index > backpack then
					minetest.log("action", string.format(cheat_log, player:get_player_name()))
					return 0
				end
			elseif inventory_info.to_list == "backpack" then
				local backpack = backpack_widths[player:get_wielded_item():get_name()]
				if not backpack or inventory_info.to_index > backpack then
					minetest.log("action", string.format(cheat_log, player:get_player_name()))
					return 0
				end
			end
		elseif action == "put" and inventory_info.listname == "backpack" then
			local backpack = backpack_widths[player:get_wielded_item():get_name()]
			if not backpack or inventory_info.index > backpack then
				minetest.log("action", string.format(cheat_log, player:get_player_name()))
				return 0
			end
		end
	end)
end

--Backpack------------------------------

local generic_doc = S("To use it, you just need to rightclick it and the interface will open exactly like a chest.")

--Amethyst
minetest.register_craftitem("mcl_backpack:amethyste_backpack", {
	description = S("@1 Backpack", C(mcl_colors.DARK_PURPLE, S("Amethyste"))),
	_doc_items_longdesc = S("Offers @1 storage slots", 9).."\n"..generic_doc,
	inventory_image = "pala_backpack_ametyst.png",
	stack_max = 1,
	groups = {miner_level = 5},
	on_use = function(itemstack, player, pointed_thing)
		minetest.show_formspec(player:get_player_name(), "mcl_backpack:amethyste", mcl_backpack.form.amethyst)
	end,
})


--Titanium
minetest.register_craftitem("mcl_backpack:titanium_backpack", {
	description = S("@1 Backpack", C(mcl_colors.DARK_GRAY, S("Titanium"))),
	_doc_items_longdesc = S("Offers @1 storage slots", 27).."\n"..generic_doc,
	inventory_image = "pala_backpack_titanium.png",
	stack_max = 1,
	groups = {miner_level = 10},
	on_use = function(itemstack, player, pointed_thing)
		minetest.show_formspec(player:get_player_name(), "mcl_backpack:titanium", mcl_backpack.form.titanium)
	end,
})

--Paladium
minetest.register_craftitem("mcl_backpack:paladium_backpack", {
	description = S("@1 Backpack", C(mcl_colors.RED, S("Paladium"))),
	_doc_items_longdesc = S("Offers @1 storage slots", 56).."\n"..generic_doc,
	inventory_image = "pala_backpack_paladium.png",
	stack_max = 1,
	groups = {miner_level = 15},
	on_use = function(itemstack, player, pointed_thing)
		minetest.show_formspec(player:get_player_name(), "mcl_backpack:paladium", mcl_backpack.form.paladium)
	end,
})

--Endium
minetest.register_craftitem("mcl_backpack:endium_backpack", {
	description = S("@1 Backpack", C(mcl_colors.BLUE, S("Endium"))),
	_doc_items_longdesc = S("Offers @1 storage slots", 81).."\n"..generic_doc,
	inventory_image = "pala_backpack_endium.png",
	stack_max = 1,
	groups = {miner_level = 20},
	on_use = function(itemstack, player, pointed_thing)
		minetest.show_formspec(player:get_player_name(), "mcl_backpack:endium", mcl_backpack.form.endium)
	end,
})

mcl_death_drop.register_dropped_list("PLAYER", "backpack", true)

--Craft (WIP) (BROKEN)
--Chest missing
if minetest.get_modpath("mcl_mobitems") and minetest.get_modpath("mcl_end") and minetest.get_modpath("mcl_amethyst") then
	minetest.register_craft({
		output = "mcl_backpack:amethyste_backpack",
		recipe = {
			{"mcl_core:iron_ingot", "mcl_chests:chest", "mcl_core:iron_ingot"},
			{"mcl_core:iron_ingot", "mcl_hoppers:hopper", "mcl_core:iron_ingot"},
			{"mcl_mobitems:leather", "mcl_amethyst:amethyst_block", "mcl_mobitems:leather"}
		},
	})
	minetest.register_craft({
		output = "mcl_backpack:titanium_backpack",
		recipe = {
			{titanium_ingot, "mcl_chests:chest", titanium_ingot},
			{titanium_ingot, "mcl_hoppers:hopper", titanium_ingot},
			{"mcl_mobitems:leather", titanium_block, "mcl_mobitems:leather"}
		},
	})
	minetest.register_craft({
		output = "mcl_backpack:paladium_backpack",
		recipe = {
			{paladium_ingot, "mcl_chests:chest", paladium_ingot},
			{paladium_ingot, "mcl_hoppers:hopper", paladium_ingot},
			{"mcl_mobitems:leather", paladium_block, "mcl_mobitems:leather"}
		},
	})
	minetest.register_craft({
		output = "mcl_backpack:endium_backpack",
		recipe = {
			{paladium_block, "mcl_chests:chest", paladium_block},
			{paladium_block, "mcl_hoppers:hopper", paladium_block},
			{"mcl_mobitems:leather", "mcl_end:end_bricks", "mcl_mobitems:leather"}
		},
	})
end

minetest.log("action", "[mcl_backpack] loaded succesfully")
