--[[==========
	STRUCTURE
	==========
	- Nodeboxes
	- Register function
]]

local S = core.get_translator("nodes4rails")

--==========
--NODEBOXES
--==========
local a=0.1
local b=0.04
local c=0.07
local d=0.024

--basic nodeboxes
local n4r_ndbx_box={-0.5,-0.5,-0.5,0.5,0.5,0.5}
local n4r_ndbx_leftside={-0.5,-0.5,-0.5,-0.5+c,0.5,0.5}
local n4r_ndbx_rightside={0.5-c,-0.5,-0.5,0.5,0.5,0.5}
local n4r_ndbx_downside={-0.5,-0.5,-0.5,0.5,-0.5+c,0.5}
local n4r_ndbx_dslab={-0.5,-0.5,-0.5,0.5,0,0.5}
local n4r_ndbx_ustair={-0.5,0,0,0.5,0.5,0.5}
local n4r_ndbx_leftunderrail={-0.5-a+d,0.5-b,-0.5,-0.5+a,0.5+b,0.5}
local n4r_ndbx_rightunderrail={0.5-a,0.5-b,-0.5,0.5+a-d,0.5+b,0.5}
--deep
--[[local n4r_ndbx_deepbox={-0.5,-1.5,-0.5,0.5,-0.5,0.5}
local n4r_ndbx_deepleftside={-0.5,-1.5,-0.5,-0.5+c,0.5,0.5}
local n4r_ndbx_deeprightside={0.5-c,-1.5,-0.5,0.5,0.5,0.5}
local n4r_ndbx_deepslab={-0.5,-1.5,-0.5,0.5,-1,0.5}
local n4r_ndbx_deepstair={-0.5,-1,0,0.5,-0.5,0.5}
local n4r_ndbx_deepdownside={-0.5,-1.5,-0.5,0.5,-1.5+c,0.5}]]

--completed nodeboxes
local n4r_nbx_u={n4r_ndbx_leftside,n4r_ndbx_rightside,n4r_ndbx_downside}
local n4r_nbx_ut={n4r_ndbx_leftside,n4r_ndbx_rightside,n4r_ndbx_downside,n4r_ndbx_rightunderrail,n4r_ndbx_leftunderrail}
local n4r_nbx_h={n4r_ndbx_leftside,n4r_ndbx_rightside,n4r_ndbx_dslab}
local n4r_nbx_ht={n4r_ndbx_leftside,n4r_ndbx_rightside,n4r_ndbx_dslab,n4r_ndbx_rightunderrail,n4r_ndbx_leftunderrail}
local n4r_nbx_s={n4r_ndbx_leftside,n4r_ndbx_rightside,n4r_ndbx_dslab,n4r_ndbx_ustair}
local n4r_nbx_st={n4r_ndbx_leftside,n4r_ndbx_rightside,n4r_ndbx_dslab,n4r_ndbx_rightunderrail,n4r_ndbx_leftunderrail,n4r_ndbx_ustair}
local n4r_nbx_i={n4r_ndbx_leftside,n4r_ndbx_rightside}
local n4r_nbx_it={n4r_ndbx_leftside,n4r_ndbx_rightside,n4r_ndbx_rightunderrail,n4r_ndbx_leftunderrail}

local nbxs = {{"u", n4r_nbx_u},{"ut", n4r_nbx_ut},{"h", n4r_nbx_h},{"ht", n4r_nbx_ht},{"s", n4r_nbx_s},{"st", n4r_nbx_st},{"i", n4r_nbx_i},{"it", n4r_nbx_it},}
local mats={"stone","stone_brick","brick","sandstone","silver_sandstone","silver_sandstone_brick"}

local function regnode(namebox,nbx,mat)
minetest.register_node("nodes4rails:" .. namebox.."_"..mat, {
description = S("Underrail tile")..", "..S("shape").." "..namebox.." "..S("from").." "..S(mat),
tiles = {"default_"..mat..".png"},
groups = {oddly_breakable_by_hand = 3},
drawtype = "nodebox",
paramtype = "light",
paramtype2 = "colorfacedir",
node_box = {
type = "fixed",
fixed = nbx,
},
is_ground_content = false,
palette = "n4r_palette.png",
})
end

for _, nbxv in ipairs(nbxs) do
	local namebox = nbxv[1]
	local nbx = nbxv[2]
for _, mat in ipairs(mats) do
    regnode(namebox,nbx,mat)
end
end
