--==========
--WIRES
--==========
local function register_wire(name, wdesc, wnodebox)
minetest.register_node("owires:" .. name, {
description = "Overhead wire - " .. wdesc,
tiles = {"bpx.png"},
groups = {cracky = 3, oddly_breakable_by_hand = 2},
drawtype = "nodebox",
paramtype = "light",
paramtype2 = "color4dir",
node_box = {
type = "fixed",
fixed = wnodebox, --nodebox for node
},
collision_box = {
type = "fixed",
fixed = {}, --without collisions
},
selection_box = {
type = "fixed",
fixed = {-0.3, 0.2, -0.3, 0.3, 0.5, 0.3}, --same for all nodes
},
sounds = default.node_sound_wood_defaults(),
is_ground_content = false,
palette = "wirepalette.png",
on_rotate = screwdriver.rotate_simple,
not_blocking_trains = 1,
		walkable = false
})
end

--straight = st
--curve = cu
--crosses: perpendicular = crp
--cross with straight = crs
--cross diagonal = crd
--slope = sl[1][2] (lenght, part) or sld[1][2] (lenght,part)
--junctions = ju[r/l/y/t][°], where r=right, l=left, y=Y turnout, t=three-ways


--==========
--Straight
--==========
register_wire("st","straight",{-0.05,0.4,-0.5,0.05,0.5,0.5})
register_wire("st30","straight 30°",{
{-0.5,0.4,-1.05,-0.45,0.5,-0.95},
{-0.5,0.4,-0.95,-0.4,0.5,-0.85},{-0.45,0.4,-0.85,-0.35,0.5,-0.75},
{-0.4,0.4,-0.75,-0.3,0.5,-0.65},{-0.35,0.4,-0.65,-0.25,0.5,-0.55},
{-0.3,0.4,-0.55,-0.2,0.5,-0.45},{-0.25,0.4,-0.45,-0.15,0.5,-0.35},
{-0.2,0.4,-0.35,-0.1,0.5,-0.25},{-0.15,0.4,-0.25,-0.05,0.5,-0.15},
{-0.1,0.4,-0.15,0,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05}})
register_wire("st45","straight 45°",{
{-0.5,0.4,-0.5,-0.45,0.5,-0.4},{-0.45,0.4,-0.5,-0.4,0.5,-0.35},{-0.4,0.4,-0.45,-0.35,0.5,-0.3},
{-0.35,0.4,-0.4,-0.3,0.5,-0.25},{-0.3,0.4,-0.35,-0.25,0.5,-0.2},{-0.25,0.4,-0.3,-0.2,0.5,-0.15},
{-0.2,0.4,-0.25,-0.15,0.5,-0.1},{-0.15,0.4,-0.2,-0.1,0.5,-0.05},{-0.1,0.4,-0.15,-0.05,0.5,0},
{-0.05,0.4,-0.1,0,0.5,0.05},{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5}})
register_wire("st60","straight 60°",{
{-1.05,0.4,-0.5,-0.95,0.5,-0.45},
{-0.95,0.4,-0.5,-0.85,0.5,-0.4},{-0.85,0.4,-0.45,-0.75,0.5,-0.35},
{-0.75,0.4,-0.4,-0.65,0.5,-0.3},{-0.65,0.4,-0.35,-0.55,0.5,-0.25},
{-0.55,0.4,-0.3,-0.45,0.5,-0.2},{-0.45,0.4,-0.25,-0.35,0.5,-0.15},
{-0.35,0.4,-0.2,-0.25,0.5,-0.1},{-0.25,0.4,-0.15,-0.15,0.5,-0.05},
{-0.15,0.4,-0.1,-0.05,0.5,0},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0.05,0.4,0,0.15,0.5,0.1},{0.15,0.4,0.05,0.25,0.5,0.15},
{0.25,0.4,0.1,0.35,0.5,0.2},{0.35,0.4,0.15,0.45,0.5,0.25},
{0.45,0.4,0.2,0.55,0.5,0.3},{0.55,0.4,0.25,0.65,0.5,0.35},
{0.65,0.4,0.3,0.75,0.5,0.4},{0.75,0.4,0.35,0.85,0.5,0.45},
{0.85,0.4,0.4,0.95,0.5,0.5},{0.95,0.4,0.45,1.05,0.5,0.5}})
register_wire("st120","straight 120°",{
{1.05,0.4,-0.5,0.95,0.5,-0.45},
{0.95,0.4,-0.5,0.85,0.5,-0.4},{0.85,0.4,-0.45,0.75,0.5,-0.35},
{0.75,0.4,-0.4,0.65,0.5,-0.3},{0.65,0.4,-0.35,0.55,0.5,-0.25},
{0.55,0.4,-0.3,0.45,0.5,-0.2},{0.45,0.4,-0.25,0.35,0.5,-0.15},
{0.35,0.4,-0.2,0.25,0.5,-0.1},{0.25,0.4,-0.15,0.15,0.5,-0.05},
{0.15,0.4,-0.1,0.05,0.5,0},{0.05,0.4,-0.05,-0.05,0.5,0.05},
{-0.05,0.4,0,-0.15,0.5,0.1},{-0.15,0.4,0.05,-0.25,0.5,0.15},
{-0.25,0.4,0.1,-0.35,0.5,0.2},{-0.35,0.4,0.15,-0.45,0.5,0.25},
{-0.45,0.4,0.2,-0.55,0.5,0.3},{-0.55,0.4,0.25,-0.65,0.5,0.35},
{-0.65,0.4,0.3,-0.75,0.5,0.4},{-0.75,0.4,0.35,-0.85,0.5,0.45},
{-0.85,0.4,0.4,-0.95,0.5,0.5},{-0.95,0.4,0.45,-1.05,0.5,0.5}})
register_wire("st135","straight 135°",{
{0.5,0.4,-0.5,0.45,0.5,-0.4},{0.45,0.4,-0.5,0.4,0.5,-0.35},{0.4,0.4,-0.45,0.35,0.5,-0.3},
{0.35,0.4,-0.4,0.3,0.5,-0.25},{0.3,0.4,-0.35,0.25,0.5,-0.2},{0.25,0.4,-0.3,0.2,0.5,-0.15},
{0.2,0.4,-0.25,0.15,0.5,-0.1},{0.15,0.4,-0.2,0.1,0.5,-0.05},{0.1,0.4,-0.15,0.05,0.5,0},
{0.05,0.4,-0.1,0,0.5,0.05},{-0.0,0.4,-0.05,-0.05,0.5,0.1},{-0.05,0.4,0,-0.1,0.5,0.15},
{-0.1,0.4,0.05,-0.15,0.5,0.2},{-0.15,0.4,0.1,-0.2,0.5,0.25},{-0.2,0.4,0.15,-0.25,0.5,0.3},
{-0.25,0.4,0.2,-0.3,0.5,0.35},{-0.3,0.4,0.25,-0.35,0.5,0.4},{-0.35,0.4,0.3,-0.4,0.5,0.45},
{-0.4,0.4,0.35,-0.45,0.5,0.5},{-0.45,0.4,0.4,-0.5,0.5,0.5}})
register_wire("st150","straight 150°",{
{0.45,0.4,-1.05,0.5,0.5,-0.95},
{0.4,0.4,-0.95,0.5,0.5,-0.85},{0.35,0.4,-0.85,0.45,0.5,-0.75},
{0.3,0.4,-0.75,0.4,0.5,-0.65},{0.25,0.4,-0.65,0.35,0.5,-0.55},
{0.2,0.4,-0.55,0.3,0.5,-0.45},{0.15,0.4,-0.45,0.25,0.5,-0.35},
{0.1,0.4,-0.35,0.2,0.5,-0.25},{0.05,0.4,-0.25,0.15,0.5,-0.15},
{0,0.4,-0.15,0.1,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{-0.1,0.4,0.05,0,0.5,0.15},{-0.15,0.4,0.15,-0.05,0.5,0.25},
{-0.2,0.4,0.25,-0.1,0.5,0.35},{-0.25,0.4,0.35,-0.15,0.5,0.45},
{-0.3,0.4,0.45,-0.2,0.5,0.55},{-0.35,0.4,0.55,-0.25,0.5,0.65},
{-0.4,0.4,0.65,-0.3,0.5,0.75},{-0.45,0.4,0.75,-0.35,0.5,0.85},
{-0.5,0.4,0.85,-0.4,0.5,0.95},{-0.5,0.4,0.95,-0.45,0.5,1.05}})

--==========
--Slopes
--==========

-- straight
---------------
register_wire("sl21", "slope 2 part 1", {
{-0.05,0.4,-0.5,0.05,0.5,-0.45},{-0.05,0.425,-0.45,0.05,0.525,-0.4},{-0.05,0.45,-0.4,0.05,0.55,-0.35},{-0.05,0.475,-0.35,0.05,0.575,-0.3},
{-0.05,0.5,-0.3,0.05,0.6,-0.25},{-0.05,0.525,-0.25,0.05,0.625,-0.2},{-0.05,0.55,-0.2,0.05,0.65,-0.15},{-0.05,0.575,-0.15,0.05,0.675,-0.1},
{-0.05,0.6,-0.1,0.05,0.7,-0.05},{-0.05,0.625,-0.05,0.05,0.725,0},{-0.05,0.65,0,0.05,0.75,0.05},{-0.05,0.675,0.05,0.05,0.775,0.1},
{-0.05,0.7,0.1,0.05,0.8,0.15},{-0.05,0.725,0.15,0.05,0.825,0.2},{-0.05,0.75,0.2,0.05,0.85,0.25},{-0.05,0.775,0.25,0.05,0.875,0.3},
{-0.05,0.8,0.3,0.05,0.9,0.35},{-0.05,0.825,0.35,0.05,0.925,0.4},{-0.05,0.85,0.4,0.05,0.95,0.45},{-0.05,0.875,0.45,0.05,0.975,0.5}
})
register_wire("sl22", "slope 2 part 2", {
{-0.05,0.9,-0.5,0.05,1.0,-0.45},{-0.05,0.925,-0.45,0.05,1.025,-0.4},{-0.05,0.95,-0.4,0.05,1.05,-0.35},{-0.05,0.975,-0.35,0.05,1.075,-0.3},
{-0.05,1.0,-0.3,0.05,1.1,-0.25},{-0.05,1.025,-0.25,0.05,1.125,-0.2},{-0.05,1.05,-0.2,0.05,1.15,-0.15},{-0.05,1.075,-0.15,0.05,1.175,-0.1},
{-0.05,1.1,-0.1,0.05,1.2,-0.05},{-0.05,1.125,-0.05,0.05,1.225,0},{-0.05,1.15,0,0.05,1.25,0.05},{-0.05,1.175,0.05,0.05,1.275,0.1},
{-0.05,1.2,0.1,0.05,1.3,0.15},{-0.05,1.225,0.15,0.05,1.325,0.2},{-0.05,1.25,0.2,0.05,1.35,0.25},{-0.05,1.275,0.25,0.05,1.375,0.3},
{-0.05,1.3,0.3,0.05,1.4,0.35},{-0.05,1.325,0.35,0.05,1.425,0.4},{-0.05,1.35,0.4,0.05,1.45,0.45},{-0.05,1.375,0.45,0.05,1.475,0.5}
})

local function register_slope_wire(name, label, y_shift_divisor, y_shift_add)
local boxes = {}
local count = 20
local x1, x2 = -0.05, 0.05
local z_start, z_step = -0.5, 0.05
local y_base = 0.4
local y_top_start = 0.5

local y_base_shifted = y_base + (y_shift_add or 0)

for i = 0, count - 1 do
local y1 = y_base_shifted + ((i * 0.05) / y_shift_divisor)
local y2 = y1 + 0.1
local z1 = z_start + i * z_step
local z2 = z1 + z_step
table.insert(boxes, {x1, y1, z1, x2, y2, z2})
end

register_wire(name, label, boxes)
end

register_slope_wire("sl31", "slope 3 part 1", 3, 0)
register_slope_wire("sl32", "slope 3 part 2", 3, 1/3)
register_slope_wire("sl33", "slope 3 part 3", 3, 2/3)


-- diagonal
---------------
register_wire("sld21","slope diagonal 2 part 1)",{
{-0.5,0.4,-0.5,-0.45,0.5,-0.4},{-0.45,0.425,-0.5,-0.4,0.525,-0.35},{-0.4,0.45,-0.45,-0.35,0.55,-0.3},
{-0.35,0.475,-0.4,-0.3,0.575,-0.25},{-0.3,0.5,-0.35,-0.25,0.6,-0.2},{-0.25,0.525,-0.3,-0.2,0.625,-0.15},
{-0.2,0.55,-0.25,-0.15,0.65,-0.1},{-0.15,0.575,-0.2,-0.1,0.675,-0.05},{-0.1,0.6,-0.15,-0.05,0.7,0},
{-0.05,0.625,-0.1,0,0.725,0.05},{0,0.675,-0.05,0.05,0.775,0.1},{0.05,0.7,0,0.1,0.8,0.15},
{0.1,0.725,0.05,0.15,0.825,0.2},{0.15,0.75,0.1,0.2,0.85,0.25},{0.2,0.775,0.15,0.25,0.875,0.3},
{0.25,0.8,0.2,0.3,0.9,0.35},{0.3,0.825,0.25,0.35,0.925,0.4},{0.35,0.85,0.3,0.4,0.95,0.45},
{0.4,0.875,0.35,0.45,0.975,0.5},{0.45,0.9,0.4,0.5,1,0.5}})
register_wire("sld22","slope diagonal 2 part 2)",{
{-0.5,0.9,-0.5,-0.45,1,-0.4},{-0.45,0.925,-0.5,-0.4,1.025,-0.35},{-0.4,0.95,-0.45,-0.35,1.05, -0.3},
{-0.35,0.975,-0.4,-0.3,1.075,-0.25},{-0.3,1,-0.35,-0.25,1.1,-0.2},{-0.25,1.025,-0.3,-0.2,1.125,-0.15},
{-0.2,1.05,-0.25,-0.15,1.15,-0.1},{-0.15,1.075,-0.2,-0.1,1.175,-0.05},{-0.1,1.1,-0.15,-0.05,1.2,0},
{-0.05,1.125,-0.1,0,1.225,0.05},{0,1.175,-0.05,0.05,1.275,0.1},{0.05,1.2,0,0.1,1.3,0.15},
{0.1,1.225,0.05,0.15,1.325,0.2},{0.15,1.25,0.1,0.2,1.35,0.25},{0.2,1.275,0.15,0.25,1.375,0.3},
{0.25,1.3,0.2,0.3,1.4,0.35},{0.3,1.325,0.25,0.35,1.425,0.4},{0.35,1.35,0.3,0.4,1.45,0.45},
{0.4,1.375,0.35,0.45,1.475,0.5},{0.45,1.4,0.4,0.5,1.5,0.5}})

--==========
--Curves
--==========
register_wire("cu","Curve from 0°",{
{-0.05,0.4,-0.5,0.05,0.5,0.05},--30°
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05}})
register_wire("cu30","Curve from 30°",{
{-0.5,0.4,-1.05,-0.45,0.5,-0.95},
{-0.5,0.4,-0.95,-0.4,0.5,-0.85},{-0.45,0.4,-0.85,-0.35,0.5,-0.75},
{-0.4,0.4,-0.75,-0.3,0.5,-0.65},{-0.35,0.4,-0.65,-0.25,0.5,-0.55},
{-0.3,0.4,-0.55,-0.2,0.5,-0.45},{-0.25,0.4,-0.45,-0.15,0.5,-0.35},
{-0.2,0.4,-0.35,-0.1,0.5,-0.25},{-0.15,0.4,-0.25,-0.05,0.5,-0.15},
{-0.1,0.4,-0.15,0,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},--45°
{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5}})
register_wire("cu45","Curve from 45°",{
{-0.5,0.4,-0.5,-0.45,0.5,-0.4},{-0.45,0.4,-0.5,-0.4,0.5,-0.35},{-0.4,0.4,-0.45,-0.35,0.5,-0.3},
{-0.35,0.4,-0.4,-0.3,0.5,-0.25},{-0.3,0.4,-0.35,-0.25,0.5,-0.2},{-0.25,0.4,-0.3,-0.2,0.5,-0.15},
{-0.2,0.4,-0.25,-0.15,0.5,-0.1},{-0.15,0.4,-0.2,-0.1,0.5,-0.05},{-0.1,0.4,-0.15,-0.05,0.5,0},
{-0.05,0.4,-0.1,0,0.5,0.05},--60°
{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0.05,0.4,0,0.15,0.5,0.1},{0.15,0.4,0.05,0.25,0.5,0.15},
{0.25,0.4,0.1,0.35,0.5,0.2},{0.35,0.4,0.15,0.45,0.5,0.25},
{0.45,0.4,0.2,0.55,0.5,0.3},{0.55,0.4,0.25,0.65,0.5,0.35},
{0.65,0.4,0.3,0.75,0.5,0.4},{0.75,0.4,0.35,0.85,0.5,0.45},
{0.85,0.4,0.4,0.95,0.5,0.5},{0.95,0.4,0.45,1.05,0.5,0.5}})
register_wire("cu60","Curve from 60°",{
{-1.05,0.4,-0.5,-0.95,0.5,-0.45},
{-0.95,0.4,-0.5,-0.85,0.5,-0.4},{-0.85,0.4,-0.45,-0.75,0.5,-0.35},
{-0.75,0.4,-0.4,-0.65,0.5,-0.3},{-0.65,0.4,-0.35,-0.55,0.5,-0.25},
{-0.55,0.4,-0.3,-0.45,0.5,-0.2},{-0.45,0.4,-0.25,-0.35,0.5,-0.15},
{-0.35,0.4,-0.2,-0.25,0.5,-0.1},{-0.25,0.4,-0.15,-0.15,0.5,-0.05},
{-0.15,0.4,-0.1,-0.05,0.5,0},{-0.05,0.4,-0.05,0.05,0.5,0.05},--90°
{-0.05,0.4,-0.05,0.5,0.5,0.05}})

--==========
--Junctions
--==========

-- right
---------------

register_wire("jur","Junction right 0°",{
{-0.05,0.4,-0.5,0.05,0.5,0.5},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05}})
register_wire("jur30","Junction right 30°",{
{-0.5,0.4,-1.05,-0.45,0.5,-0.95},
{-0.5,0.4,-0.95,-0.4,0.5,-0.85},{-0.45,0.4,-0.85,-0.35,0.5,-0.75},
{-0.4,0.4,-0.75,-0.3,0.5,-0.65},{-0.35,0.4,-0.65,-0.25,0.5,-0.55},
{-0.3,0.4,-0.55,-0.2,0.5,-0.45},{-0.25,0.4,-0.45,-0.15,0.5,-0.35},
{-0.2,0.4,-0.35,-0.1,0.5,-0.25},{-0.15,0.4,-0.25,-0.05,0.5,-0.15},
{-0.1,0.4,-0.15,0,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05},
{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5}})
register_wire("jur45","Junction right 45°",{
{-0.5,0.4,-0.5,-0.45,0.5,-0.4},{-0.45,0.4,-0.5,-0.4,0.5,-0.35},{-0.4,0.4,-0.45,-0.35,0.5,-0.3},
{-0.35,0.4,-0.4,-0.3,0.5,-0.25},{-0.3,0.4,-0.35,-0.25,0.5,-0.2},{-0.25,0.4,-0.3,-0.2,0.5,-0.15},
{-0.2,0.4,-0.25,-0.15,0.5,-0.1},{-0.15,0.4,-0.2,-0.1,0.5,-0.05},{-0.1,0.4,-0.15,-0.05,0.5,0},
{-0.05,0.4,-0.1,0,0.5,0.05},{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5},
{0.05,0.4,-0.05,-0.05,0.5,0.05}, --60°
{1.05,0.4,0.45,0.95,0.5,0.5},
{0.95,0.4,0.4,0.85,0.5,0.5},{0.85,0.4,0.35,0.75,0.5,0.45},
{0.75,0.4,0.3,0.65,0.5,0.4},{0.65,0.4,0.25,0.55,0.5,0.35},
{0.55,0.4,0.2,0.45,0.5,0.3},{0.45,0.4,0.15,0.35,0.5,0.25},
{0.35,0.4,0.1,0.25,0.5,0.2},{0.25,0.4,0.05,0.15,0.5,0.15},
{0.15,0.4,0,0.05,0.5,0.1}})
register_wire("jur60","Junction right 60°",{
{1.05,0.4,0.45,0.95,0.5,0.5},
{0.95,0.4,0.4,0.85,0.5,0.5},{0.85,0.4,0.35,0.75,0.5,0.45},
{0.75,0.4,0.3,0.65,0.5,0.4},{0.65,0.4,0.25,0.55,0.5,0.35},
{0.55,0.4,0.2,0.45,0.5,0.3},{0.45,0.4,0.15,0.35,0.5,0.25},
{0.35,0.4,0.1,0.25,0.5,0.2},{0.25,0.4,0.05,0.15,0.5,0.15},
{0.15,0.4,0,0.05,0.5,0.1},{0.05,0.4,-0.05,-0.05,0.5,0.05},
{-0.05,0.4,-0.1,-0.15,0.5,0},{-0.15,0.4,-0.15,-0.25,0.5,-0.05},
{-0.25,0.4,-0.2,-0.35,0.5,-0.1},{-0.35,0.4,-0.25,-0.45,0.5,-0.15},
{-0.45,0.4,-0.3,-0.55,0.5,-0.2},{-0.55,0.4,-0.35,-0.65,0.5,-0.25},
{-0.65,0.4,-0.4,-0.75,0.5,-0.3},{-0.75,0.4,-0.45,-0.85,0.5,-0.35},
{-0.85,0.4,-0.5,-0.95,0.5,-0.4},{-0.95,0.4,-0.55,-1.05,0.5,-0.45},{-0.05,0.4,-0.05,0.5,0.5,0.05}})

-- left
---------------

register_wire("jul","Junction left 0°",{
{0.05,0.4,-0.5,-0.05,0.5,0.5},{0.05,0.4,-0.05,-0.05,0.5,-0.05},
{-0.1,0.4,0.05,-0.1,0.5,0.15},{-0.05,0.4,0.15,-0.15,0.5,0.25},
{-0.1,0.4,0.25,-0.2,0.5,0.35},{-0.15,0.4,0.35,-0.25,0.5,0.45},
{-0.2,0.4,0.45,-0.3,0.5,0.55},{-0.25,0.4,0.55,-0.35,0.5,0.65},
{-0.3,0.4,0.65,-0.4,0.5,0.75},{-0.35,0.4,0.75,-0.45,0.5,0.85},
{-0.4,0.4,0.85,-0.5,0.5,0.95},{-0.45,0.4,0.95,-0.5,0.5,1.05}})
register_wire("jul30","Junction left 30°",{
{0.5,0.4,-1.05,0.45,0.5,-0.95},
{0.5,0.4,-0.95,0.4,0.5,-0.85},{0.45,0.4,-0.85,0.35,0.5,-0.75},
{0.4,0.4,-0.75,0.3,0.5,-0.65},{0.35,0.4,-0.65,0.25,0.5,-0.55},
{0.3,0.4,-0.55,0.2,0.5,-0.45},{0.25,0.4,-0.45,0.15,0.5,-0.35},
{0.2,0.4,-0.35,0.1,0.5,-0.25},{0.15,0.4,-0.25,0.05,0.5,-0.15},
{0.1,0.4,-0.15,0,0.5,-0.05},{0.05,0.4,-0.05,-0.05,0.5,0.05},
{0,0.4,0.05,-0.1,0.5,0.15},{-0.05,0.4,0.15,-0.15,0.5,0.25},
{-0.1,0.4,0.25,-0.2,0.5,0.35},{-0.15,0.4,0.35,-0.25,0.5,0.45},
{-0.2,0.4,0.45,-0.3,0.5,0.55},{-0.25,0.4,0.55,-0.35,0.5,0.65},
{-0.3,0.4,0.65,-0.4,0.5,0.75},{-0.35,0.4,0.75,-0.45,0.5,0.85},
{-0.4,0.4,0.85,-0.5,0.5,0.95},{-0.45,0.4,0.95,-0.5,0.5,1.05},
{0,0.4,-0.05,-0.05,0.5,0.1},{-0.05,0.4,0,-0.1,0.5,0.15},
{-0.1,0.4,0.05,-0.15,0.5,0.2},{-0.15,0.4,0.1,-0.2,0.5,0.25},{-0.2,0.4,0.15,-0.25,0.5,0.3},
{-0.25,0.4,0.2,-0.3,0.5,0.35},{-0.3,0.4,0.25,-0.35,0.5,0.4},{-0.35,0.4,0.3,-0.4,0.5,0.45},
{-0.4,0.4,0.35,-0.45,0.5,0.5},{-0.45,0.4,0.4,-0.5,0.5,0.5}})
register_wire("jul45","Junction left 45°",{
{0.5,0.4,-0.5,0.45,0.5,-0.4},{0.45,0.4,-0.5,0.4,0.5,-0.35},{0.4,0.4,-0.45,0.35,0.5,-0.3},
{0.35,0.4,-0.4,0.3,0.5,-0.25},{0.3,0.4,-0.35,0.25,0.5,-0.2},{0.25,0.4,-0.3,0.2,0.5,-0.15},
{0.2,0.4,-0.25,0.15,0.5,-0.1},{0.15,0.4,-0.2,0.1,0.5,-0.05},{0.1,0.4,-0.15,0.05,0.5,0},
{0.05,0.4,-0.1,0,0.5,0.05},{0,0.4,-0.05,-0.05,0.5,0.1},{-0.05,0.4,0,-0.1,0.5,0.15},
{-0.1,0.4,0.05,-0.15,0.5,0.2},{-0.15,0.4,0.1,-0.2,0.5,0.25},{-0.2,0.4,0.15,-0.25,0.5,0.3},
{-0.25,0.4,0.2,-0.3,0.5,0.35},{-0.3,0.4,0.25,-0.35,0.5,0.4},{-0.35,0.4,0.3,-0.4,0.5,0.45},
{-0.4,0.4,0.35,-0.45,0.5,0.5},{-0.45,0.4,0.4,-0.5,0.5,0.5},
{-0.05,0.4,-0.05,0.05,0.5,0.05}, --60°
{-1.05,0.4,0.45,-0.95,0.5,0.5},
{-0.95,0.4,0.4,-0.85,0.5,0.5},{-0.85,0.4,0.35,-0.75,0.5,0.45},
{-0.75,0.4,0.3,-0.65,0.5,0.4},{-0.65,0.4,0.25,-0.55,0.5,0.35},
{-0.55,0.4,0.2,-0.45,0.5,0.3},{-0.45,0.4,0.15,-0.35,0.5,0.25},
{-0.35,0.4,0.1,-0.25,0.5,0.2},{-0.25,0.4,0.05,-0.15,0.5,0.15},
{-0.15,0.4,0,-0.05,0.5,0.1}})
register_wire("jul60","Junction left 60°",{
{-1.05,0.4,0.45,-0.95,0.5,0.5},
{-0.95,0.4,0.4,-0.85,0.5,0.5},{-0.85,0.4,0.35,-0.75,0.5,0.45},
{-0.75,0.4,0.3,-0.65,0.5,0.4},{-0.65,0.4,0.25,-0.55,0.5,0.35},
{-0.55,0.4,0.2,-0.45,0.5,0.3},{-0.45,0.4,0.15,-0.35,0.5,0.25},
{-0.35,0.4,0.1,-0.25,0.5,0.2},{-0.25,0.4,0.05,-0.15,0.5,0.15},
{-0.15,0.4,0,-0.05,0.5,0.1},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0.05,0.4,-0.1,0.15,0.5,0},{0.15,0.4,-0.15,0.25,0.5,-0.05},
{0.25,0.4,-0.2,0.35,0.5,-0.1},{0.35,0.4,-0.25,0.45,0.5,-0.15},
{0.45,0.4,-0.3,0.55,0.5,-0.2},{0.55,0.4,-0.35,0.65,0.5,-0.25},
{0.65,0.4,-0.4,0.75,0.5,-0.3},{0.75,0.4,-0.45,0.85,0.5,-0.35},
{0.85,0.4,-0.5,0.95,0.5,-0.4},{0.95,0.4,-0.55,1.05,0.5,-0.45},{0.05,0.4,-0.05,-0.5,0.5,0.05}})

-- Y
---------------

register_wire("juy","Junction Y 0°",{
{-0.05,0.4,-0.5,0.05,0.5,0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05}, --left part
{-0.1,0.4,0.05,0,0.5,0.15},{-0.15,0.4,0.15,-0.05,0.5,0.25},
{-0.2,0.4,0.25,-0.1,0.5,0.35},{-0.25,0.4,0.35,-0.15,0.5,0.45},
{-0.3,0.4,0.45,-0.2,0.5,0.55},{-0.35,0.4,0.55,-0.25,0.5,0.65},
{-0.4,0.4,0.65,-0.3,0.5,0.75},{-0.45,0.4,0.75,-0.35,0.5,0.85},
{-0.5,0.4,0.85,-0.4,0.5,0.95},{-0.5,0.4,0.95,-0.45,0.5,1.05}})
register_wire("juy30","Junction Y 30°",{
{-0.5,0.4,-1.05,-0.45,0.5,-0.95},
{-0.5,0.4,-0.95,-0.4,0.5,-0.85},{-0.45,0.4,-0.85,-0.35,0.5,-0.75},
{-0.4,0.4,-0.75,-0.3,0.5,-0.65},{-0.35,0.4,-0.65,-0.25,0.5,-0.55},
{-0.3,0.4,-0.55,-0.2,0.5,-0.45},{-0.25,0.4,-0.45,-0.15,0.5,-0.35},
{-0.2,0.4,-0.35,-0.1,0.5,-0.25},{-0.15,0.4,-0.25,-0.05,0.5,-0.15},
{-0.1,0.4,-0.15,0,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},--0°
{-0.05,0.4,0.05,0.05,0.5,0.5},--45°
{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5}})
register_wire("juy45","Junction Y 45°",{
{-0.5,0.4,-0.5,-0.45,0.5,-0.4},{-0.45,0.4,-0.5,-0.4,0.5,-0.35},{-0.4,0.4,-0.45,-0.35,0.5,-0.3},
{-0.35,0.4,-0.4,-0.3,0.5,-0.25},{-0.3,0.4,-0.35,-0.25,0.5,-0.2},{-0.25,0.4,-0.3,-0.2,0.5,-0.15},
{-0.2,0.4,-0.25,-0.15,0.5,-0.1},{-0.15,0.4,-0.2,-0.1,0.5,-0.05},{-0.1,0.4,-0.15,-0.05,0.5,0},
{-0.05,0.4,-0.1,0,0.5,0.05},{0,0.4,-0.05,0.05,0.5,0.1},--30°
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05}, --60°
{1.05,0.4,0.45,0.95,0.5,0.5},
{0.95,0.4,0.4,0.85,0.5,0.5},{0.85,0.4,0.35,0.75,0.5,0.45},
{0.75,0.4,0.3,0.65,0.5,0.4},{0.65,0.4,0.25,0.55,0.5,0.35},
{0.55,0.4,0.2,0.45,0.5,0.3},{0.45,0.4,0.15,0.35,0.5,0.25},
{0.35,0.4,0.1,0.25,0.5,0.2},{0.25,0.4,0.05,0.15,0.5,0.15},
{0.15,0.4,0,0.05,0.5,0.1}})
register_wire("juy60","Junction Y 60°",{
{-1.05,0.4,-0.5,-0.95,0.5,-0.45},
{-0.95,0.4,-0.5,-0.85,0.5,-0.4},{-0.85,0.4,-0.45,-0.75,0.5,-0.35},
{-0.75,0.4,-0.4,-0.65,0.5,-0.3},{-0.65,0.4,-0.35,-0.55,0.5,-0.25},
{-0.55,0.4,-0.3,-0.45,0.5,-0.2},{-0.45,0.4,-0.25,-0.35,0.5,-0.15},
{-0.35,0.4,-0.2,-0.25,0.5,-0.1},{-0.25,0.4,-0.15,-0.15,0.5,-0.05},
{-0.15,0.4,-0.1,-0.05,0.5,0},--45°
{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5},--90°
{-0.05,0.4,-0.05,0.5,0.5,0.05}})


-- triple-way
---------------

register_wire("jut","Junction triple-way 0°",{
{-0.05,0.4,-0.5,0.05,0.5,0.5},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05},--left part
{-0.1,0.4,0.05,0,0.5,0.15},{-0.15,0.4,0.15,-0.05,0.5,0.25},
{-0.2,0.4,0.25,-0.1,0.5,0.35},{-0.25,0.4,0.35,-0.15,0.5,0.45},
{-0.3,0.4,0.45,-0.2,0.5,0.55},{-0.35,0.4,0.55,-0.25,0.5,0.65},
{-0.4,0.4,0.65,-0.3,0.5,0.75},{-0.45,0.4,0.75,-0.35,0.5,0.85},
{-0.5,0.4,0.85,-0.4,0.5,0.95},{-0.5,0.4,0.95,-0.45,0.5,1.05}})
register_wire("jut30","Junction triple-way 30°",{
{-0.05,0.4,0.05,0.05,0.5,0.5},{-0.5,0.4,-1.05,-0.45,0.5,-0.95},
{-0.5,0.4,-0.95,-0.4,0.5,-0.85},{-0.45,0.4,-0.85,-0.35,0.5,-0.75},
{-0.4,0.4,-0.75,-0.3,0.5,-0.65},{-0.35,0.4,-0.65,-0.25,0.5,-0.55},
{-0.3,0.4,-0.55,-0.2,0.5,-0.45},{-0.25,0.4,-0.45,-0.15,0.5,-0.35},
{-0.2,0.4,-0.35,-0.1,0.5,-0.25},{-0.15,0.4,-0.25,-0.05,0.5,-0.15},
{-0.1,0.4,-0.15,0,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05},
{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5}})
register_wire("jut45","Junction triple-way 45°",{
{-0.5,0.4,-0.5,-0.45,0.5,-0.4},{-0.45,0.4,-0.5,-0.4,0.5,-0.35},{-0.4,0.4,-0.45,-0.35,0.5,-0.3},
{-0.35,0.4,-0.4,-0.3,0.5,-0.25},{-0.3,0.4,-0.35,-0.25,0.5,-0.2},{-0.25,0.4,-0.3,-0.2,0.5,-0.15},
{-0.2,0.4,-0.25,-0.15,0.5,-0.1},{-0.15,0.4,-0.2,-0.1,0.5,-0.05},{-0.1,0.4,-0.15,-0.05,0.5,0},
{-0.05,0.4,-0.1,0,0.5,0.05},{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5},
{0.05,0.4,-0.05,-0.05,0.5,0.05}, --60°
{1.05,0.4,0.45,0.95,0.5,0.5},
{0.95,0.4,0.4,0.85,0.5,0.5},{0.85,0.4,0.35,0.75,0.5,0.45},
{0.75,0.4,0.3,0.65,0.5,0.4},{0.65,0.4,0.25,0.55,0.5,0.35},
{0.55,0.4,0.2,0.45,0.5,0.3},{0.45,0.4,0.15,0.35,0.5,0.25},
{0.35,0.4,0.1,0.25,0.5,0.2},{0.25,0.4,0.05,0.15,0.5,0.15},
{0.15,0.4,0,0.05,0.5,0.1},--30°
{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05},
{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5}})
register_wire("jut60","Junction triple-way 60°",{
{1.05,0.4,0.45,0.95,0.5,0.5},
{0.95,0.4,0.4,0.85,0.5,0.5},{0.85,0.4,0.35,0.75,0.5,0.45},
{0.75,0.4,0.3,0.65,0.5,0.4},{0.65,0.4,0.25,0.55,0.5,0.35},
{0.55,0.4,0.2,0.45,0.5,0.3},{0.45,0.4,0.15,0.35,0.5,0.25},
{0.35,0.4,0.1,0.25,0.5,0.2},{0.25,0.4,0.05,0.15,0.5,0.15},
{0.15,0.4,0,0.05,0.5,0.1},{0.05,0.4,-0.05,-0.05,0.5,0.05},
{-0.05,0.4,-0.1,-0.15,0.5,0},{-0.15,0.4,-0.15,-0.25,0.5,-0.05},
{-0.25,0.4,-0.2,-0.35,0.5,-0.1},{-0.35,0.4,-0.25,-0.45,0.5,-0.15},
{-0.45,0.4,-0.3,-0.55,0.5,-0.2},{-0.55,0.4,-0.35,-0.65,0.5,-0.25},
{-0.65,0.4,-0.4,-0.75,0.5,-0.3},{-0.75,0.4,-0.45,-0.85,0.5,-0.35},
{-0.85,0.4,-0.5,-0.95,0.5,-0.4},{-0.95,0.4,-0.55,-1.05,0.5,-0.45},{-0.05,0.4,-0.05,0.5,0.5,0.05},--45°
{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5}})

--==========
--CROSSES
--==========

--straight
---------------
register_wire("crs30","Cross straight 30°",{
{-0.05,0.4,-0.5,0.05,0.5,0.5},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05}, --left part
{-0.5,0.4,-1.05,-0.45,0.5,-0.95},
{-0.5,0.4,-0.95,-0.4,0.5,-0.85},{-0.45,0.4,-0.85,-0.35,0.5,-0.75},
{-0.4,0.4,-0.75,-0.3,0.5,-0.65},{-0.35,0.4,-0.65,-0.25,0.5,-0.55},
{-0.3,0.4,-0.55,-0.2,0.5,-0.45},{-0.25,0.4,-0.45,-0.15,0.5,-0.35},
{-0.2,0.4,-0.35,-0.1,0.5,-0.25},{-0.15,0.4,-0.25,-0.05,0.5,-0.15},
{-0.1,0.4,-0.15,0,0.5,-0.05}})
register_wire("crs45","Cross straight 45°",{
{-0.05,0.4,-0.5,0.05,0.5,0.5},
{-0.5,0.4,-0.5,-0.45,0.5,-0.4},{-0.45,0.4,-0.5,-0.4,0.5,-0.35},{-0.4,0.4,-0.45,-0.35,0.5,-0.3},
{-0.35,0.4,-0.4,-0.3,0.5,-0.25},{-0.3,0.4,-0.35,-0.25,0.5,-0.2},{-0.25,0.4,-0.3,-0.2,0.5,-0.15},
{-0.2,0.4,-0.25,-0.15,0.5,-0.1},{-0.15,0.4,-0.2,-0.1,0.5,-0.05},{-0.1,0.4,-0.15,-0.05,0.5,0},
{-0.05,0.4,-0.1,0,0.5,0.05},{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5}
})
register_wire("crs120","Cross straight 120°",{
{-0.05,0.4,-0.5,0.05,0.5,0.5},
{1.05,0.4,-0.5,0.95,0.5,-0.45},
{0.95,0.4,-0.5,0.85,0.5,-0.4},{0.85,0.4,-0.45,0.75,0.5,-0.35},
{0.75,0.4,-0.4,0.65,0.5,-0.3},{0.65,0.4,-0.35,0.55,0.5,-0.25},
{0.55,0.4,-0.3,0.45,0.5,-0.2},{0.45,0.4,-0.25,0.35,0.5,-0.15},
{0.35,0.4,-0.2,0.25,0.5,-0.1},{0.25,0.4,-0.15,0.15,0.5,-0.05},
{0.15,0.4,-0.1,0.05,0.5,0},{0.05,0.4,-0.05,-0.05,0.5,0.05},
{-0.05,0.4,0,-0.15,0.5,0.1},{-0.15,0.4,0.05,-0.25,0.5,0.15},
{-0.25,0.4,0.1,-0.35,0.5,0.2},{-0.35,0.4,0.15,-0.45,0.5,0.25},
{-0.45,0.4,0.2,-0.55,0.5,0.3},{-0.55,0.4,0.25,-0.65,0.5,0.35},
{-0.65,0.4,0.3,-0.75,0.5,0.4},{-0.75,0.4,0.35,-0.85,0.5,0.45},
{-0.85,0.4,0.4,-0.95,0.5,0.5},{-0.95,0.4,0.45,-1.05,0.5,0.5}})
register_wire("crs60","Cross straight 60°",{
{-0.05,0.4,-0.5,0.05,0.5,0.5},
{1.05,0.4,0.45,0.95,0.5,0.5},
{0.95,0.4,0.4,0.85,0.5,0.5},{0.85,0.4,0.35,0.75,0.5,0.45},
{0.75,0.4,0.3,0.65,0.5,0.4},{0.65,0.4,0.25,0.55,0.5,0.35},
{0.55,0.4,0.2,0.45,0.5,0.3},{0.45,0.4,0.15,0.35,0.5,0.25},
{0.35,0.4,0.1,0.25,0.5,0.2},{0.25,0.4,0.05,0.15,0.5,0.15},
{0.15,0.4,0,0.05,0.5,0.1},{0.05,0.4,-0.05,-0.05,0.5,0.05},
{-0.05,0.4,-0.1,-0.15,0.5,0},{-0.15,0.4,-0.15,-0.25,0.5,-0.05},
{-0.25,0.4,-0.2,-0.35,0.5,-0.1},{-0.35,0.4,-0.25,-0.45,0.5,-0.15},
{-0.45,0.4,-0.3,-0.55,0.5,-0.2},{-0.55,0.4,-0.35,-0.65,0.5,-0.25},
{-0.65,0.4,-0.4,-0.75,0.5,-0.3},{-0.75,0.4,-0.45,-0.85,0.5,-0.35},
{-0.85,0.4,-0.5,-0.95,0.5,-0.4},{-0.95,0.4,-0.5,-1.05,0.5,-0.45}})
register_wire("crs135","Cross straight 135°",{
{-0.05,0.4,-0.5,0.05,0.5,0.5},
{0.5,0.4,-0.5,0.45,0.5,-0.4},{0.45,0.4,-0.5,0.4,0.5,-0.35},{0.4,0.4,-0.45,0.35,0.5,-0.3},
{0.35,0.4,-0.4,0.3,0.5,-0.25},{0.3,0.4,-0.35,0.25,0.5,-0.2},{0.25,0.4,-0.3,0.2,0.5,-0.15},
{0.2,0.4,-0.25,0.15,0.5,-0.1},{0.15,0.4,-0.2,0.1,0.5,-0.05},{0.1,0.4,-0.15,0.05,0.5,0},
{0.05,0.4,-0.1,0,0.5,0.05},{-0.0,0.4,-0.05,-0.05,0.5,0.1},{-0.05,0.4,0,-0.1,0.5,0.15},
{-0.1,0.4,0.05,-0.15,0.5,0.2},{-0.15,0.4,0.1,-0.2,0.5,0.25},{-0.2,0.4,0.15,-0.25,0.5,0.3},
{-0.25,0.4,0.2,-0.3,0.5,0.35},{-0.3,0.4,0.25,-0.35,0.5,0.4},{-0.35,0.4,0.3,-0.4,0.5,0.45},
{-0.4,0.4,0.35,-0.45,0.5,0.5},{-0.45,0.4,0.4,-0.5,0.5,0.5}})
register_wire("crs150","Cross straight 150°",{
{-0.05,0.4,-0.5,0.05,0.5,0.5},
{0.45,0.4,-1.05,0.5,0.5,-0.95},
{0.4,0.4,-0.95,0.5,0.5,-0.85},{0.35,0.4,-0.85,0.45,0.5,-0.75},
{0.3,0.4,-0.75,0.4,0.5,-0.65},{0.25,0.4,-0.65,0.35,0.5,-0.55},
{0.2,0.4,-0.55,0.3,0.5,-0.45},{0.15,0.4,-0.45,0.25,0.5,-0.35},
{0.1,0.4,-0.35,0.2,0.5,-0.25},{0.05,0.4,-0.25,0.15,0.5,-0.15},
{0,0.4,-0.15,0.1,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{-0.1,0.4,0.05,0,0.5,0.15},{-0.15,0.4,0.15,-0.05,0.5,0.25},
{-0.2,0.4,0.25,-0.1,0.5,0.35},{-0.25,0.4,0.35,-0.15,0.5,0.45},
{-0.3,0.4,0.45,-0.2,0.5,0.55},{-0.35,0.4,0.55,-0.25,0.5,0.65},
{-0.4,0.4,0.65,-0.3,0.5,0.75},{-0.45,0.4,0.75,-0.35,0.5,0.85},
{-0.5,0.4,0.85,-0.4,0.5,0.95},{-0.5,0.4,0.95,-0.45,0.5,1.05}})

--perpendicular
---------------
register_wire("crp","Cross perpendicular 0°",{
{-0.05,0.4,-0.5,0.05,0.5,0.5},{-0.5,0.4,-0.05,0.5,0.5,0.05}})
register_wire("crp30","Cross perpendicular 0°",{
{-0.5,0.4,-1.05,-0.45,0.5,-0.95},
{-0.5,0.4,-0.95,-0.4,0.5,-0.85},{-0.45,0.4,-0.85,-0.35,0.5,-0.75},
{-0.4,0.4,-0.75,-0.3,0.5,-0.65},{-0.35,0.4,-0.65,-0.25,0.5,-0.55},
{-0.3,0.4,-0.55,-0.2,0.5,-0.45},{-0.25,0.4,-0.45,-0.15,0.5,-0.35},
{-0.2,0.4,-0.35,-0.1,0.5,-0.25},{-0.15,0.4,-0.25,-0.05,0.5,-0.15},
{-0.1,0.4,-0.15,0,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05},--120°
{1.05,0.4,-0.5,0.95,0.5,-0.45},
{0.95,0.4,-0.5,0.85,0.5,-0.4},{0.85,0.4,-0.45,0.75,0.5,-0.35},
{0.75,0.4,-0.4,0.65,0.5,-0.3},{0.65,0.4,-0.35,0.55,0.5,-0.25},
{0.55,0.4,-0.3,0.45,0.5,-0.2},{0.45,0.4,-0.25,0.35,0.5,-0.15},
{0.35,0.4,-0.2,0.25,0.5,-0.1},{0.25,0.4,-0.15,0.15,0.5,-0.05},
{0.15,0.4,-0.1,0.05,0.5,0},{0.05,0.4,-0.05,-0.05,0.5,0.05},
{-0.05,0.4,0,-0.15,0.5,0.1},{-0.15,0.4,0.05,-0.25,0.5,0.15},
{-0.25,0.4,0.1,-0.35,0.5,0.2},{-0.35,0.4,0.15,-0.45,0.5,0.25},
{-0.45,0.4,0.2,-0.55,0.5,0.3},{-0.55,0.4,0.25,-0.65,0.5,0.35},
{-0.65,0.4,0.3,-0.75,0.5,0.4},{-0.75,0.4,0.35,-0.85,0.5,0.45},
{-0.85,0.4,0.4,-0.95,0.5,0.5},{-0.95,0.4,0.45,-1.05,0.5,0.5}
})
register_wire("crp45","Cross perpendicular 0°",{
{-0.5,0.4,-0.5,-0.45,0.5,-0.4},{-0.45,0.4,-0.5,-0.4,0.5,-0.35},{-0.4,0.4,-0.45,-0.35,0.5,-0.3},
{-0.35,0.4,-0.4,-0.3,0.5,-0.25},{-0.3,0.4,-0.35,-0.25,0.5,-0.2},{-0.25,0.4,-0.3,-0.2,0.5,-0.15},
{-0.2,0.4,-0.25,-0.15,0.5,-0.1},{-0.15,0.4,-0.2,-0.1,0.5,-0.05},{-0.1,0.4,-0.15,-0.05,0.5,0},
{-0.05,0.4,-0.1,0,0.5,0.05},{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5},--135°
{0.5,0.4,-0.5,0.45,0.5,-0.4},{0.45,0.4,-0.5,0.4,0.5,-0.35},{0.4,0.4,-0.45,0.35,0.5,-0.3},
{0.35,0.4,-0.4,0.3,0.5,-0.25},{0.3,0.4,-0.35,0.25,0.5,-0.2},{0.25,0.4,-0.3,0.2,0.5,-0.15},
{0.2,0.4,-0.25,0.15,0.5,-0.1},{0.15,0.4,-0.2,0.1,0.5,-0.05},{0.1,0.4,-0.15,0.05,0.5,0},
{0.05,0.4,-0.1,0,0.5,0.05},{-0.0,0.4,-0.05,-0.05,0.5,0.1},{-0.05,0.4,0,-0.1,0.5,0.15},
{-0.1,0.4,0.05,-0.15,0.5,0.2},{-0.15,0.4,0.1,-0.2,0.5,0.25},{-0.2,0.4,0.15,-0.25,0.5,0.3},
{-0.25,0.4,0.2,-0.3,0.5,0.35},{-0.3,0.4,0.25,-0.35,0.5,0.4},{-0.35,0.4,0.3,-0.4,0.5,0.45},
{-0.4,0.4,0.35,-0.45,0.5,0.5},{-0.45,0.4,0.4,-0.5,0.5,0.5}})
register_wire("crp60","Cross perpendicular 0°",{
{-1.05,0.4,-0.5,-0.95,0.5,-0.45},
{-0.95,0.4,-0.5,-0.85,0.5,-0.4},{-0.85,0.4,-0.45,-0.75,0.5,-0.35},
{-0.75,0.4,-0.4,-0.65,0.5,-0.3},{-0.65,0.4,-0.35,-0.55,0.5,-0.25},
{-0.55,0.4,-0.3,-0.45,0.5,-0.2},{-0.45,0.4,-0.25,-0.35,0.5,-0.15},
{-0.35,0.4,-0.2,-0.25,0.5,-0.1},{-0.25,0.4,-0.15,-0.15,0.5,-0.05},
{-0.15,0.4,-0.1,-0.05,0.5,0},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0.05,0.4,0,0.15,0.5,0.1},{0.15,0.4,0.05,0.25,0.5,0.15},
{0.25,0.4,0.1,0.35,0.5,0.2},{0.35,0.4,0.15,0.45,0.5,0.25},
{0.45,0.4,0.2,0.55,0.5,0.3},{0.55,0.4,0.25,0.65,0.5,0.35},
{0.65,0.4,0.3,0.75,0.5,0.4},{0.75,0.4,0.35,0.85,0.5,0.45},
{0.85,0.4,0.4,0.95,0.5,0.5},{0.95,0.4,0.45,1.05,0.5,0.5},--150°
{0.45,0.4,-1.05,0.5,0.5,-0.95},
{0.4,0.4,-0.95,0.5,0.5,-0.85},{0.35,0.4,-0.85,0.45,0.5,-0.75},
{0.3,0.4,-0.75,0.4,0.5,-0.65},{0.25,0.4,-0.65,0.35,0.5,-0.55},
{0.2,0.4,-0.55,0.3,0.5,-0.45},{0.15,0.4,-0.45,0.25,0.5,-0.35},
{0.1,0.4,-0.35,0.2,0.5,-0.25},{0.05,0.4,-0.25,0.15,0.5,-0.15},
{0,0.4,-0.15,0.1,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{-0.1,0.4,0.05,0,0.5,0.15},{-0.15,0.4,0.15,-0.05,0.5,0.25},
{-0.2,0.4,0.25,-0.1,0.5,0.35},{-0.25,0.4,0.35,-0.15,0.5,0.45},
{-0.3,0.4,0.45,-0.2,0.5,0.55},{-0.35,0.4,0.55,-0.25,0.5,0.65},
{-0.4,0.4,0.65,-0.3,0.5,0.75},{-0.45,0.4,0.75,-0.35,0.5,0.85},
{-0.5,0.4,0.85,-0.4,0.5,0.95},{-0.5,0.4,0.95,-0.45,0.5,1.05}})

--diagonal
---------------
register_wire("crd3045","Cross diagonal 30° x 45°",{
{-0.5,0.4,-1.05,-0.45,0.5,-0.95},
{-0.5,0.4,-0.95,-0.4,0.5,-0.85},{-0.45,0.4,-0.85,-0.35,0.5,-0.75},
{-0.4,0.4,-0.75,-0.3,0.5,-0.65},{-0.35,0.4,-0.65,-0.25,0.5,-0.55},
{-0.3,0.4,-0.55,-0.2,0.5,-0.45},{-0.25,0.4,-0.45,-0.15,0.5,-0.35},
{-0.2,0.4,-0.35,-0.1,0.5,-0.25},{-0.15,0.4,-0.25,-0.05,0.5,-0.15},
{-0.1,0.4,-0.15,0,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05},--45°
{-0.5,0.4,-0.5,-0.45,0.5,-0.4},{-0.45,0.4,-0.5,-0.4,0.5,-0.35},{-0.4,0.4,-0.45,-0.35,0.5,-0.3},
{-0.35,0.4,-0.4,-0.3,0.5,-0.25},{-0.3,0.4,-0.35,-0.25,0.5,-0.2},{-0.25,0.4,-0.3,-0.2,0.5,-0.15},
{-0.2,0.4,-0.25,-0.15,0.5,-0.1},{-0.15,0.4,-0.2,-0.1,0.5,-0.05},{-0.1,0.4,-0.15,-0.05,0.5,0},
{-0.05,0.4,-0.1,0,0.5,0.05},{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5}})
register_wire("crd3060","Cross diagonal 30° x 60°",{
{-0.5,0.4,-1.05,-0.45,0.5,-0.95},
{-0.5,0.4,-0.95,-0.4,0.5,-0.85},{-0.45,0.4,-0.85,-0.35,0.5,-0.75},
{-0.4,0.4,-0.75,-0.3,0.5,-0.65},{-0.35,0.4,-0.65,-0.25,0.5,-0.55},
{-0.3,0.4,-0.55,-0.2,0.5,-0.45},{-0.25,0.4,-0.45,-0.15,0.5,-0.35},
{-0.2,0.4,-0.35,-0.1,0.5,-0.25},{-0.15,0.4,-0.25,-0.05,0.5,-0.15},
{-0.1,0.4,-0.15,0,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05},--60°
{-1.05,0.4,-0.5,-0.95,0.5,-0.45},
{-0.95,0.4,-0.5,-0.85,0.5,-0.4},{-0.85,0.4,-0.45,-0.75,0.5,-0.35},
{-0.75,0.4,-0.4,-0.65,0.5,-0.3},{-0.65,0.4,-0.35,-0.55,0.5,-0.25},
{-0.55,0.4,-0.3,-0.45,0.5,-0.2},{-0.45,0.4,-0.25,-0.35,0.5,-0.15},
{-0.35,0.4,-0.2,-0.25,0.5,-0.1},{-0.25,0.4,-0.15,-0.15,0.5,-0.05},
{-0.15,0.4,-0.1,-0.05,0.5,0},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0.05,0.4,0,0.15,0.5,0.1},{0.15,0.4,0.05,0.25,0.5,0.15},
{0.25,0.4,0.1,0.35,0.5,0.2},{0.35,0.4,0.15,0.45,0.5,0.25},
{0.45,0.4,0.2,0.55,0.5,0.3},{0.55,0.4,0.25,0.65,0.5,0.35},
{0.65,0.4,0.3,0.75,0.5,0.4},{0.75,0.4,0.35,0.85,0.5,0.45},
{0.85,0.4,0.4,0.95,0.5,0.5},{0.95,0.4,0.45,1.05,0.5,0.5}})
register_wire("crd30135","Cross diagonal 30° x 135°",{
{-0.5,0.4,-1.05,-0.45,0.5,-0.95},
{-0.5,0.4,-0.95,-0.4,0.5,-0.85},{-0.45,0.4,-0.85,-0.35,0.5,-0.75},
{-0.4,0.4,-0.75,-0.3,0.5,-0.65},{-0.35,0.4,-0.65,-0.25,0.5,-0.55},
{-0.3,0.4,-0.55,-0.2,0.5,-0.45},{-0.25,0.4,-0.45,-0.15,0.5,-0.35},
{-0.2,0.4,-0.35,-0.1,0.5,-0.25},{-0.15,0.4,-0.25,-0.05,0.5,-0.15},
{-0.1,0.4,-0.15,0,0.5,-0.05},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0,0.4,0.05,0.1,0.5,0.15},{0.05,0.4,0.15,0.15,0.5,0.25},
{0.1,0.4,0.25,0.2,0.5,0.35},{0.15,0.4,0.35,0.25,0.5,0.45},
{0.2,0.4,0.45,0.3,0.5,0.55},{0.25,0.4,0.55,0.35,0.5,0.65},
{0.3,0.4,0.65,0.4,0.5,0.75},{0.35,0.4,0.75,0.45,0.5,0.85},
{0.4,0.4,0.85,0.5,0.5,0.95},{0.45,0.4,0.95,0.5,0.5,1.05},--135°
{0.5,0.4,-0.5,0.45,0.5,-0.4},{0.45,0.4,-0.5,0.4,0.5,-0.35},{0.4,0.4,-0.45,0.35,0.5,-0.3},
{0.35,0.4,-0.4,0.3,0.5,-0.25},{0.3,0.4,-0.35,0.25,0.5,-0.2},{0.25,0.4,-0.3,0.2,0.5,-0.15},
{0.2,0.4,-0.25,0.15,0.5,-0.1},{0.15,0.4,-0.2,0.1,0.5,-0.05},{0.1,0.4,-0.15,0.05,0.5,0},
{0.05,0.4,-0.1,0,0.5,0.05},{-0.0,0.4,-0.05,-0.05,0.5,0.1},{-0.05,0.4,0,-0.1,0.5,0.15},
{-0.1,0.4,0.05,-0.15,0.5,0.2},{-0.15,0.4,0.1,-0.2,0.5,0.25},{-0.2,0.4,0.15,-0.25,0.5,0.3},
{-0.25,0.4,0.2,-0.3,0.5,0.35},{-0.3,0.4,0.25,-0.35,0.5,0.4},{-0.35,0.4,0.3,-0.4,0.5,0.45},
{-0.4,0.4,0.35,-0.45,0.5,0.5},{-0.45,0.4,0.4,-0.5,0.5,0.5}})
register_wire("crd6045","Cross diagonal 60° x 45°",{
{-1.05,0.4,-0.5,-0.95,0.5,-0.45},
{-0.95,0.4,-0.5,-0.85,0.5,-0.4},{-0.85,0.4,-0.45,-0.75,0.5,-0.35},
{-0.75,0.4,-0.4,-0.65,0.5,-0.3},{-0.65,0.4,-0.35,-0.55,0.5,-0.25},
{-0.55,0.4,-0.3,-0.45,0.5,-0.2},{-0.45,0.4,-0.25,-0.35,0.5,-0.15},
{-0.35,0.4,-0.2,-0.25,0.5,-0.1},{-0.25,0.4,-0.15,-0.15,0.5,-0.05},
{-0.15,0.4,-0.1,-0.05,0.5,0},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0.05,0.4,0,0.15,0.5,0.1},{0.15,0.4,0.05,0.25,0.5,0.15},
{0.25,0.4,0.1,0.35,0.5,0.2},{0.35,0.4,0.15,0.45,0.5,0.25},
{0.45,0.4,0.2,0.55,0.5,0.3},{0.55,0.4,0.25,0.65,0.5,0.35},
{0.65,0.4,0.3,0.75,0.5,0.4},{0.75,0.4,0.35,0.85,0.5,0.45},
{0.85,0.4,0.4,0.95,0.5,0.5},{0.95,0.4,0.45,1.05,0.5,0.5},--45°
{-0.5,0.4,-0.5,-0.45,0.5,-0.4},{-0.45,0.4,-0.5,-0.4,0.5,-0.35},{-0.4,0.4,-0.45,-0.35,0.5,-0.3},
{-0.35,0.4,-0.4,-0.3,0.5,-0.25},{-0.3,0.4,-0.35,-0.25,0.5,-0.2},{-0.25,0.4,-0.3,-0.2,0.5,-0.15},
{-0.2,0.4,-0.25,-0.15,0.5,-0.1},{-0.15,0.4,-0.2,-0.1,0.5,-0.05},{-0.1,0.4,-0.15,-0.05,0.5,0},
{-0.05,0.4,-0.1,0,0.5,0.05},{0,0.4,-0.05,0.05,0.5,0.1},{0.05,0.4,0,0.1,0.5,0.15},
{0.1,0.4,0.05,0.15,0.5,0.2},{0.15,0.4,0.1,0.2,0.5,0.25},{0.2,0.4,0.15,0.25,0.5,0.3},
{0.25,0.4,0.2,0.3,0.5,0.35},{0.3,0.4,0.25,0.35,0.5,0.4},{0.35,0.4,0.3,0.4,0.5,0.45},
{0.4,0.4,0.35,0.45,0.5,0.5},{0.45,0.4,0.4,0.5,0.5,0.5}})
register_wire("crd60120","Cross diagonal 60° x 120°",{
{-1.05,0.4,-0.5,-0.95,0.5,-0.45},
{-0.95,0.4,-0.5,-0.85,0.5,-0.4},{-0.85,0.4,-0.45,-0.75,0.5,-0.35},
{-0.75,0.4,-0.4,-0.65,0.5,-0.3},{-0.65,0.4,-0.35,-0.55,0.5,-0.25},
{-0.55,0.4,-0.3,-0.45,0.5,-0.2},{-0.45,0.4,-0.25,-0.35,0.5,-0.15},
{-0.35,0.4,-0.2,-0.25,0.5,-0.1},{-0.25,0.4,-0.15,-0.15,0.5,-0.05},
{-0.15,0.4,-0.1,-0.05,0.5,0},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0.05,0.4,0,0.15,0.5,0.1},{0.15,0.4,0.05,0.25,0.5,0.15},
{0.25,0.4,0.1,0.35,0.5,0.2},{0.35,0.4,0.15,0.45,0.5,0.25},
{0.45,0.4,0.2,0.55,0.5,0.3},{0.55,0.4,0.25,0.65,0.5,0.35},
{0.65,0.4,0.3,0.75,0.5,0.4},{0.75,0.4,0.35,0.85,0.5,0.45},
{0.85,0.4,0.4,0.95,0.5,0.5},{0.95,0.4,0.45,1.05,0.5,0.5},--120°
{1.05,0.4,-0.5,0.95,0.5,-0.45},
{0.95,0.4,-0.5,0.85,0.5,-0.4},{0.85,0.4,-0.45,0.75,0.5,-0.35},
{0.75,0.4,-0.4,0.65,0.5,-0.3},{0.65,0.4,-0.35,0.55,0.5,-0.25},
{0.55,0.4,-0.3,0.45,0.5,-0.2},{0.45,0.4,-0.25,0.35,0.5,-0.15},
{0.35,0.4,-0.2,0.25,0.5,-0.1},{0.25,0.4,-0.15,0.15,0.5,-0.05},
{0.15,0.4,-0.1,0.05,0.5,0},{0.05,0.4,-0.05,-0.05,0.5,0.05},
{-0.05,0.4,0,-0.15,0.5,0.1},{-0.15,0.4,0.05,-0.25,0.5,0.15},
{-0.25,0.4,0.1,-0.35,0.5,0.2},{-0.35,0.4,0.15,-0.45,0.5,0.25},
{-0.45,0.4,0.2,-0.55,0.5,0.3},{-0.55,0.4,0.25,-0.65,0.5,0.35},
{-0.65,0.4,0.3,-0.75,0.5,0.4},{-0.75,0.4,0.35,-0.85,0.5,0.45},
{-0.85,0.4,0.4,-0.95,0.5,0.5},{-0.95,0.4,0.45,-1.05,0.5,0.5}})
register_wire("crd60135","Cross diagonal 60° x 135°",{
{-1.05,0.4,-0.5,-0.95,0.5,-0.45},
{-0.95,0.4,-0.5,-0.85,0.5,-0.4},{-0.85,0.4,-0.45,-0.75,0.5,-0.35},
{-0.75,0.4,-0.4,-0.65,0.5,-0.3},{-0.65,0.4,-0.35,-0.55,0.5,-0.25},
{-0.55,0.4,-0.3,-0.45,0.5,-0.2},{-0.45,0.4,-0.25,-0.35,0.5,-0.15},
{-0.35,0.4,-0.2,-0.25,0.5,-0.1},{-0.25,0.4,-0.15,-0.15,0.5,-0.05},
{-0.15,0.4,-0.1,-0.05,0.5,0},{-0.05,0.4,-0.05,0.05,0.5,0.05},
{0.05,0.4,0,0.15,0.5,0.1},{0.15,0.4,0.05,0.25,0.5,0.15},
{0.25,0.4,0.1,0.35,0.5,0.2},{0.35,0.4,0.15,0.45,0.5,0.25},
{0.45,0.4,0.2,0.55,0.5,0.3},{0.55,0.4,0.25,0.65,0.5,0.35},
{0.65,0.4,0.3,0.75,0.5,0.4},{0.75,0.4,0.35,0.85,0.5,0.45},
{0.85,0.4,0.4,0.95,0.5,0.5},{0.95,0.4,0.45,1.05,0.5,0.5},--135°
{0.5,0.4,-0.5,0.45,0.5,-0.4},{0.45,0.4,-0.5,0.4,0.5,-0.35},{0.4,0.4,-0.45,0.35,0.5,-0.3},
{0.35,0.4,-0.4,0.3,0.5,-0.25},{0.3,0.4,-0.35,0.25,0.5,-0.2},{0.25,0.4,-0.3,0.2,0.5,-0.15},
{0.2,0.4,-0.25,0.15,0.5,-0.1},{0.15,0.4,-0.2,0.1,0.5,-0.05},{0.1,0.4,-0.15,0.05,0.5,0},
{0.05,0.4,-0.1,0,0.5,0.05},{-0.0,0.4,-0.05,-0.05,0.5,0.1},{-0.05,0.4,0,-0.1,0.5,0.15},
{-0.1,0.4,0.05,-0.15,0.5,0.2},{-0.15,0.4,0.1,-0.2,0.5,0.25},{-0.2,0.4,0.15,-0.25,0.5,0.3},
{-0.25,0.4,0.2,-0.3,0.5,0.35},{-0.3,0.4,0.25,-0.35,0.5,0.4},{-0.35,0.4,0.3,-0.4,0.5,0.45},
{-0.4,0.4,0.35,-0.45,0.5,0.5},{-0.45,0.4,0.4,-0.5,0.5,0.5}})
