
# Advtrains Train Controller
![Screenshot from git repo](https://notabug.org/Maverick2797/advtrains_train_controller/raw/master/screenshot.png)
This mod provides a rebindable remote control for use with the advtrains mod.

## How To Use

### Binding To A Train
Punch a locomotive with the controller to bind it to that locomotive. The controller will remain bound to the locomotive specifically, not the train as a whole, enabling the user to retain control of the locomotive during shunting when the train id may change.

Note: the controller will **only** bind to locomotives, i.e. anything with `is_locomotive = true` in the advtrains registered definition.

### Rebinding To A New Train
To rebind the controller to another locomotive simply click the `Bind To New Train` button. The saved locomotive will be erased from memory, ready for the user to rebind as above.

### Train Information
The `External Display`, `Internal Display`, `Routing Code` and `Line` fields are read from the bound train when the user punches to use the controller. If any of these fields change between reading from the train and when the user clicks `Update Train Info` then the changes made will be written to the train, overwriting any changes that the train may have accumulated in the meantime (e.g. Inside Display text being changed by a station track.)

### Train Control
The `Set Speed` field is also read from the train when the user uses the controller, except that it will read the train's actual speed at the time. The speed will only be sent to the train when the `Confirm` button is clicked.

The `Send ATC` field performs exactly as if the train passed over an ATC track section in the direction of the arrow. The user can use this to pre-program manoeuvres instead of constantly returning to the controller. See the documentation for the [ATC Controller](https://advtrains.de/wiki/doku.php?id=usage:nodes:atc_controller) for commands and syntax. The command is immediately sent to the train when `Send` is clicked and not kept in memory across controller uses.

The `Disable ARS` and `Autocouple` checkboxes also will be read from the train when the user uses the controller. `Autocouple` will show as ticked if the train has been set to couple by either the `Cpl` ATC command or `set_autocouple()` LuaATC command. Manually ticking the checkbox has the same effect as `set_autocouple()`. `Disable ARS` requires the `advtrains_interlocking` sub-mod to be enabled to be effective, and has the equivalent effect as the `A` ATC command and `atc_set_ars_disable()` LuaATC command.

## Priv Requirements
Due to the ability to control a train from anywhere on the server, the `train_admin` priv is required to use this tool.

## Dependencies:
- advtrains
- default & advtrains_luaautomation for craft recipe only (not required for the code to work)

## Licenses:
This work is protected under the following licenses:
- Code: MIT
- Artwork: CC-BY-SA-4.0

A copy of each license is included in the `LICENSES` folder