local S = core.get_translator(core.get_current_modname())
local ui = unified_inventory

ui.register_category("at1_locomotives",{
	-- symbol = "advtrains:newlocomotive",
	symbol = "advtrains_engine_steam_inv.png",
	label = S("AdvTrains Locomotives")
})
ui.register_category("at2_rollingstock",{
	-- symbol = "advtrains:wagon_default",
	symbol = "advtrains_wagon_inv.png",
	label = S("AdvTrains Rollingstock")
})
ui.register_category("at3_interlocking",{
	-- symbol = "advtrains:retrosignal_off",
	symbol = "advtrains_retrosignal_inv.png",
	label = S("AdvTrains Interlocking & Signals")
})
ui.register_category("at4_track", {
	-- symbol = "advtrains:dtrack_placer",
	symbol = "advtrains_dtrack_placer.png",
	label = S("AdvTrains Track")
})

core.register_on_mods_loaded(function()
	for name, def in pairs(core.registered_items) do
		local group = def.groups or {}
		if group.at_loco or group.at_control then
			ui.add_category_item("at1_locomotives", name)
		end
		if group.at_pax or group.at_freight or (group.at_rideable and not group.at_loco) then
			ui.add_category_item("at2_rollingstock", name)
		end
		if group.advtrains_signal then
			ui.add_category_item("at3_interlocking", name)
		end
		if group.advtrains_trackplacer then
			ui.add_category_item("at4_track", name)
		end
	end
	local manual_entry = {
		-- tools
		['advtrains:trackworker'] = "at3_interlocking",
		['advtrains:wagon_prop_tool'] = "at3_interlocking",
		['advtrains_interlocking:tool'] = "at3_interlocking",
		['advtrains_interlocking:tcb_node'] = "at3_interlocking",
		['advtrains_trackmap:tool'] = "at3_interlocking",
		-- misc signalling
		['advtrains_signals_ks:mast_mast_0'] = "at3_interlocking",
		['advtrains_signals_ks:zs3v_off_0'] = "at3_interlocking",
		['advtrains_signals_ks:zs3_off_0'] = "at3_interlocking",
		['advtrains_signals_japan:pole_0'] = "at3_interlocking",
		-- misc track-related
		['advtrains:dtrack_slopeplacer'] = "at4_track",
		['advtrains_luaautomation:oppanel'] = "at4_track",
		['advtrains_luaautomation:mesecon_controller0000'] = "at4_track"
	}
	for name, cat in pairs(manual_entry) do
		ui.add_category_item(cat, name)
	end
end)