--doorbell mod

local doorbell_way = {}
minetest.register_node("doorbell:doorbell_marker", {
    tiles = {"doorbell_marker.png"},
    description = "doorbell marker",
    groups = {cracky = 1},
	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("owner", "")
	end,
	after_place_node = function(pos, placer)
		local meta = minetest.get_meta(pos)
		meta:set_string("owner", placer:get_player_name() or "")
	end,

    on_rightclick = function(pos, node, player, itemstack, pointed_thing)
		local player_name = player:get_player_name()
        local meta = minetest.get_meta(pos)
        local owner_name = meta:get_string("owner")
		local owner_player = minetest.get_player_by_name(owner_name)

		if not doorbell_way[player_name] then
			doorbell_way[player_name] = player:hud_add({
				hud_elem_type = "waypoint",
				world_pos = pos,
				name = "Doorbell",
				text = pos,
				number = 0xEDF010,
			})
		end
		if owner_player and owner_name ~= player_name and not doorbell_way[owner_name] then
			doorbell_way[owner_name] = owner_player:hud_add({
				hud_elem_type = "waypoint",
				world_pos = pos,
				name = "Doorbell",
				text = pos,
				number = 0xEDF010,
			})
		end
		minetest.sound_play("deurbel1")
    end,
	on_punch = function(pos, node, player, pointed_thing)
		local player_name = player:get_player_name()
        local meta = minetest.get_meta(pos)
        local owner_name = meta:get_string("owner")
		local owner_player = minetest.get_player_by_name(owner_name)

		if doorbell_way[player_name] then
			player:hud_remove(doorbell_way[player_name])
			doorbell_way[player_name] = nil
		end
		if owner_player and owner_name ~= player_name and doorbell_way[owner_name] then
			owner_player:hud_remove(doorbell_way[owner_name])
			doorbell_way[owner_name] = nil
		end
    end,
})

minetest.register_craft({
	output = '"doorbell:doorbell_marker" 1',
	recipe = {
		{'wool:black', 'wool:black', 'wool:black'},
		{'wool:black', 'wool:blue', 'wool:black'},
		{'wool:black', 'wool:black', 'wool:black'},
	}
})