mesecon.button_turnoff = function (pos)
	local node = minetest.get_node(pos)
	if node.name ~= "doorbell:button_on" then -- has been dug
		return
	end
	minetest.swap_node(pos, {name = "doorbell:button_off", param2 = node.param2})
end

minetest.register_node("doorbell:button_off", {
	drawtype = "nodebox",
	tiles = {
	"doorbell_button_sides.png",
	"doorbell_button_sides.png",
	"doorbell_button_sides.png",
	"doorbell_button_sides.png",
	"doorbell_button_sides.png",
	"doorbell_button_off.png"
	},
	paramtype = "light",
	paramtype2 = "facedir",
	is_ground_content = false,
	legacy_wallmounted = true,
	walkable = false,
	sunlight_propagates = true,
	selection_box = {
	type = "fixed",
		fixed = { -6/16, -6/16, 5/16, 6/16, 6/16, 8/16 }
	},
	node_box = {
		type = "fixed",
		fixed = {
		{ -6/16, -6/16, 6/16, 6/16, 6/16, 8/16 },	-- the thin plate behind the button
		{ -4/16, -2/16, 4/16, 4/16, 2/16, 6/16 }	-- the button itself
	}
	},
	groups = {dig_immediate=2},
	description = "doorbell 3D",
	on_rightclick = function (pos, node)
		minetest.swap_node(pos, {name = "doorbell:button_on", param2=node.param2})
		doorbell_play(pos, "deurbel1")
		minetest.get_node_timer(pos):start(1)
	end,
	sounds = default.node_sound_stone_defaults(),
	on_blast = mesecon.on_blastnode,
})

minetest.register_node("doorbell:button_on", {
	drawtype = "nodebox",
	tiles = {
		"doorbell_button_sides.png",
		"doorbell_button_sides.png",
		"doorbell_button_sides.png",
		"doorbell_button_sides.png",
		"doorbell_button_sides.png",
		"doorbell_button_on.png"
		},
	paramtype = "light",
	paramtype2 = "facedir",
	is_ground_content = false,
	legacy_wallmounted = true,
	walkable = false,
	on_rotate = false,
	light_source = minetest.LIGHT_MAX-7,
	sunlight_propagates = true,
	selection_box = {
		type = "fixed",
		fixed = { -6/16, -6/16, 5/16, 6/16, 6/16, 8/16 }
	},
	node_box = {
	type = "fixed",
	fixed = {
		{ -6/16, -6/16,  6/16, 6/16, 6/16, 8/16 },
		{ -4/16, -2/16, 11/32, 4/16, 2/16, 6/16 }
	}
    },
	groups = {dig_immediate=2, not_in_creative_inventory=1},
	drop = 'doorbell:button_off',
	description = "doorbell 3D",
	sounds = default.node_sound_stone_defaults(),
	on_timer = mesecon.button_turnoff,
	on_blast = mesecon.on_blastnode,
})

minetest.register_craft({
	output = "doorbell:button_off 2",
	recipe = {
		{"doorbell:doorbell","mesecons_button:button_off"},
	}
})
