--title mod
title = {}
dofile(minetest.get_modpath("title").."/functions.lua")

minetest.register_chatcommand("title", {
	params = "<player> <command> | <player> <method> <text> | <player> <command> <stay>", -- clear | <title¦subtitle> <titleText> | times <fadeIn> <stay> <fadeOut>
	description = "shows a title in a players HUD",
	func = function(name, param)
		local wordsinparam = {}
		for word in string.gmatch(param, "[^%s]+") do
		   table.insert(wordsinparam, word)
		end
		if wordsinparam[2] == "clear" then 
			title.clear_hud(wordsinparam[1])
		elseif wordsinparam[2] == "times" then
			title.set_times(wordsinparam[1], wordsinparam[3])
		else 
			local playername, method, text = title.decode(param)
			title.set_title(playername, method, text)
		end
	end, 
})
