local idx = {}
title.clear_hud = function(playername)
	local player = minetest.get_player_by_name(playername)
	if idx[playername] then
		player:hud_remove(idx[playername])
		idx[playername] = nil
    end
end

title.set_title = function(playername, method, text)
	local player = minetest.get_player_by_name(playername)
	if not idx[playername] then
		if method == "title" then
			idx[playername] = player:hud_add({
				hud_elem_type = "text",
				position = {x = 0.5, y = 0.53},
				offset = {x = 0, y = 0},
				text = text,
				alignment = {x = 0, y = 0},
				scale = {x = 100, y = 100},
				number = 0x00FF00,
			})
		elseif method == "subtitle" then
			idx[playername] = player:hud_add({
				hud_elem_type = "text",
				position = {x = 0.5, y = 0.7},
				offset = {x = 0, y = 0},
				text = text,
				alignment = {x = 0, y = 0},
				number = 0xFF0000,
			})
		else 
			minetest.chat_send_player(playername, "param does not match")
		end
	end
end

title.set_times = function(playername, stay)
	minetest.after(stay, function()
		local player = minetest.get_player_by_name(playername)
		if idx[playername] then
			player:hud_remove(idx[playername])
			idx[playername] = nil
		end
	end)
end

title.decode = function(var)
	local t = {}
	local test = " " 
	for i in string.gmatch(var, "%S+") do
	   test = test .. " " .. i
	end
	for str in string.gmatch(test, "%S+") do
	  table.insert(t, str)
	end
	local username = t[1]
	local command = t[2]
	local text = " "
	local a = 3
	while a < #t or a == #t do
		text = text .. " " .. t[a]
		a = a + 1
	end
	return username, command, text
end
