local S = minetest.get_translator(minetest.get_current_modname())

local function create_soil(pos, inv)
	if pos == nil then
		return false
	end
	local node = minetest.get_node(pos)
	local name = node.name
	local above = minetest.get_node({x=pos.x, y=pos.y+1, z=pos.z})
	if minetest.get_item_group(name, "cultivatable") == 2 then
		if above.name == "air" then
			node.name = "mcl_farming:soil"
			minetest.set_node(pos, node)
			minetest.sound_play("default_dig_crumbly", { pos = pos, gain = 0.5 }, true)
			return true
		end
	elseif minetest.get_item_group(name, "cultivatable") == 1 then
		if above.name == "air" then
			node.name = "mcl_core:dirt"
			minetest.set_node(pos, node)
			minetest.sound_play("default_dig_crumbly", { pos = pos, gain = 0.6 }, true)
			return true
		end
	end
	return false
end

local hoe_on_place_function = function(wear_divisor)
	return function(itemstack, user, pointed_thing)
		-- Call on_rightclick if the pointed node defines it
		local node = minetest.get_node(pointed_thing.under)
		if user and not user:get_player_control().sneak then
			if minetest.registered_nodes[node.name] and minetest.registered_nodes[node.name].on_rightclick then
				return minetest.registered_nodes[node.name].on_rightclick(pointed_thing.under, node, user, itemstack) or itemstack
			end
		end

		if minetest.is_protected(pointed_thing.under, user:get_player_name()) then
			minetest.record_protection_violation(pointed_thing.under, user:get_player_name())
			return itemstack
		end

		if create_soil(pointed_thing.under, user:get_inventory()) then
			if not minetest.is_creative_enabled(user:get_player_name()) then
				itemstack:add_wear(65535/wear_divisor)
				tt.reload_itemstack_description(itemstack) -- update tooltip
			end
			return itemstack
		end
	end
end

local uses = {
	-- wood = 60,
	-- stone = 132,
	copper = 140,
	bronze = 201,
	-- iron = 251,
	-- gold = 33,
	-- diamond = 1562,
	-- netherite = 2031,
}
-- frm mcl ...\games\mineclone2\mods\ITEMS\mcl_farming
local hoe_tt = S("Turns block into farmland")
local hoe_longdesc = S("Hoes are essential tools for growing crops. They are used to create farmland in order to plant seeds on it. Hoes can also be used as very weak weapons in a pinch.")
local hoe_usagehelp = S("Use the hoe on a cultivatable block (by rightclicking it) to turn it into farmland. Dirt, grass blocks and grass paths are cultivatable blocks. Using a hoe on coarse dirt turns it into dirt.")

minetest.register_tool("mcl_bronze_stuff:hoe_bronze", {
	description = S("Bronze Hoe"),
	_tt_help = hoe_tt.."\n"..S("Uses: @1", uses.bronze),
	_doc_items_longdesc = hoe_longdesc,
	_doc_items_usagehelp = hoe_usagehelp,
	inventory_image = "default_tool_bronzehoe.png",
	wield_scale = mcl_vars.tool_wield_scale,
	on_place = hoe_on_place_function(uses.bronze),
	groups = { tool=1, hoe=1, enchantability=14 },
	tool_capabilities = {
		-- 1/3
		full_punch_interval = 0.33333333,
		damage_groups = { fleshy = 1, },
		punch_attack_uses = uses.bronze,
	},
	_repair_material = "mcl_bronze_stuff:bronze_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		hoey = { speed = 6, level = 4, uses = 201 }
	},
})

minetest.register_craft({
	output = "mcl_bronze_stuff:hoe_bronze",
	recipe = {
		{"mcl_bronze_stuff:bronze_ingot", "mcl_bronze_stuff:bronze_ingot"},
		{"", "mcl_core:stick"},
		{"", "mcl_core:stick"}
	}
})
minetest.register_craft({
	output = "mcl_bronze_stuff:hoe_bronze",
	recipe = {
		{"mcl_bronze_stuff:bronze_ingot", "mcl_bronze_stuff:bronze_ingot"},
		{"mcl_core:stick", ""},
		{"mcl_core:stick", ""}
	}
})

--- 
--- Copper 
--- 
minetest.register_tool("mcl_bronze_stuff:hoe_copper", {
	description = S("Copper Hoe"),
	_tt_help = hoe_tt.."\n"..S("Uses: @1", uses.copper),
	_doc_items_longdesc = hoe_longdesc,
	_doc_items_usagehelp = hoe_usagehelp,
	inventory_image = "default_tool_copperhoe.png",
	wield_scale = mcl_vars.tool_wield_scale,
	on_place = hoe_on_place_function(uses.copper),
	groups = { tool=1, hoe=1, enchantability=14 },
	tool_capabilities = {
		-- 1/3
		full_punch_interval = 0.33333333,
		damage_groups = { fleshy = 1, },
		punch_attack_uses = uses.copper,
	},
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		hoey = { speed = 6, level = 4, uses = 140 }
	},
})

minetest.register_craft({
	output = "mcl_bronze_stuff:hoe_copper",
	recipe = {
		{"mcl_copper:copper_ingot", "mcl_copper:copper_ingot"},
		{"", "mcl_core:stick"},
		{"", "mcl_core:stick"}
	}
})
minetest.register_craft({
	output = "mcl_bronze_stuff:hoe_copper",
	recipe = {
		{"mcl_copper:copper_ingot", "mcl_copper:copper_ingot"},
		{"mcl_core:stick", ""},
		{"mcl_core:stick", ""}
	}
}) 	