local S = core.get_translator(core.get_current_modname());

main = {
    wood_path = "mcl_trees:wood_",
    woods = {
        "acacia", "birch",  "oak", "dark_oak",  "spruce",  "jungle",
        "bamboo", "mangrove", "cherry_blossom", "warped", "crimson",
    },
}

-- Add Item to Inventory
function main.add_item_to_inventory(user, item_id)
    local inv = user:get_inventory();
    if inv:room_for_item("main", {name=item_id}) then
        inv:add_item("main", item_id);
    else
        local pos = user:get_pos();
        pos.y = math.floor(pos.y + 0.5);
        core.add_item(pos, item_id);
    end
end

function main.eat_item(itemstack, user, pointed_thing, sound, item_id, loot)
    core.sound_play(sound, {to_player = user:get_player_name(), gain = 0.7}, true);
    core.item_eat(item_id)(itemstack, user, pointed_thing);
    
    if loot ~= nil then
        main.add_item_to_inventory(user, loot);
    end
end

-- CAPITALIZE TEXT
function main.capitalize(str)
    return (str:gsub("^%l", string.upper))
end

-- -----------------------------------------------------------

-- IMPORTS
local mod_path = core.get_modpath("craftoplus");

-- PLANTS
dofile(mod_path.."/plants/crops/wheat.lua");

-- OBSIDIAN
dofile(mod_path.."/materials/obsidian.lua");

-- COPPER
dofile(mod_path.."/materials/copper/copper.lua");
dofile(mod_path.."/materials/copper/tools.lua");
dofile(mod_path.."/materials/copper/chains.lua");
dofile(mod_path.."/materials/copper/lantern.lua");

dofile(mod_path.."/materials/copper/crafts.lua");

-- GOLD
dofile(mod_path.."/materials/gold/chains.lua");
dofile(mod_path.."/materials/gold/lantern.lua");
dofile(mod_path.."/materials/gold/door.lua");

dofile(mod_path.."/materials/gold/crafts.lua");

-- IRON
dofile(mod_path.."/materials/iron/crafts.lua");

-- FOOD
dofile(mod_path.."/food/egg.lua");
dofile(mod_path.."/food/milk.lua");
dofile(mod_path.."/food/bread.lua");
dofile(mod_path.."/food/chocolate.lua");
dofile(mod_path.."/food/cookie.lua");

-- OTHER
dofile(mod_path.."/other/bottle.lua");
dofile(mod_path.."/other/honey.lua");
dofile(mod_path.."/other/loot.lua");