local S = core.get_translator(core.get_current_modname());

-- VILLAGES
function mcl_villages.fill_chest(pos, pr)
    -- initialize chest (mts chests don't have meta)
    local meta = core.get_meta(pos)
    if meta:get_string("infotext") ~= "Chest" then
        core.registered_nodes["mcl_chests:chest_small"].on_construct(pos)
    end
    -- fill chest
    local inv = core.get_inventory( {type="node", pos=pos} )

    local function get_treasures(prand)
        local loottable = {{
            stacks_min = 3,
            stacks_max = 8,
            items = {
                { itemstring = "mcl_torches:torch", weight = 15, amount_min = 1, amount_max = 10 },
                { itemstring = "mcl_core:diamond", weight = 3, amount_min = 1, amount_max = 3 },
                { itemstring = "mcl_core:iron_ingot", weight = 10, amount_min = 1, amount_max = 5 },
                { itemstring = "mcl_books:book", weight = 10, amount_min = 1, amount_max = 5 },
                { itemstring = "mcl_core:gold_ingot", weight = 5, amount_min = 1, amount_max = 3 },
                { itemstring = "mcl_farming:bread", weight = 15, amount_min = 1, amount_max = 3 },
                { itemstring = "mcl_farming:wheat_item", weight = 10, amount_min = 1, amount_max = 4 },
                { itemstring = "mcl_farming:cookie", weight = 20, amount_min = 1, amount_max = 5 },
                { itemstring = "mcl_honey:honey_bottle", weight = 5, amount_min = 1, amount_max = 2 },
                { itemstring = "mcl_core:sugar", weight = 8, amount_min = 1, amount_max = 2 },
                { itemstring = "mcl_core:apple", weight = 15, amount_min = 1, amount_max = 3 },
                { itemstring = "mcl_tools:pick_iron", weight = 5 },
                { itemstring = "mcl_tools:sword_iron", weight = 5 },
                { itemstring = "mcl_farming:pumpkin_pie", weight = 7, amount_min = 1, amount_max = 3 },
                { itemstring = "mcl_cake:cake", weight = 3 },
                { itemstring = "mcl_armor:chestplate_iron", weight = 5 },
                { itemstring = "mcl_armor:helmet_iron", weight = 5 },
                { itemstring = "mcl_armor:leggings_iron", weight = 5 },
                { itemstring = "mcl_armor:boots_iron", weight = 5 },
                { itemstring = "mcl_core:obsidian", weight = 5, amount_min = 3, amount_max = 7 },
                { itemstring = "mcl_core:sapling", weight = 5, amount_min = 3, amount_max = 7 },
                { itemstring = "mcl_mobitems:saddle", weight = 3 },
                { itemstring = "mcl_mobitems:iron_horse_armor", weight = 1 },
                { itemstring = "mcl_mobitems:gold_horse_armor", weight = 1 },
                { itemstring = "mcl_mobitems:diamond_horse_armor", weight = 1 },
            }
        }}
        local items = mcl_loot.get_multi_loot(loottable, prand);
        return items;
    end

    local items = get_treasures(pr);
    mcl_loot.fill_inventory(inv, "main", items, pr);
end


-- RAIL CORRIDORS
function tsm_railcorridors.get_treasures(pr)
    local loottable = {
    {
        stacks_min = 1,
        stacks_max = 1,
        items = {
            { itemstring = "mcl_mobitems:nametag", weight = 30 },
            { itemstring = "mcl_core:apple_gold", weight = 20 },
            { itemstring = "mcl_books:book", weight = 10, func = function(stack, pr)
                mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr)
            end },
            { itemstring = "", weight = 5},
            { itemstring = "mcl_core:pick_iron", weight = 5 },
            { itemstring = "mcl_core:apple_gold_enchanted", weight = 1 },
            { itemstring = "mcl_core:diamond", weight = 15, amount_min = 1, amount_max = 9 },
        }
    },
    {
        stacks_min = 1,
        stacks_max = 7,
        items = {
            { itemstring = "mcl_torches:torch", weight = 15, amount_min = 1, amount_max = 10 },
            { itemstring = "mcl_core:stone", weight = 5, amount_min = 1, amount_max = 5 },
            { itemstring = "mcl_core:cobble", weight = 15, amount_min = 1, amount_max = 15 },
            { itemstring = "mcl_raw_ores:raw_iron", weight = 15, amount_min = 1, amount_max = 10 },
            { itemstring = "mcl_raw_ores:raw_gold", weight = 10, amount_min = 1, amount_max = 8 },
            { itemstring = "mcl_redstone:redstone", weight = 30, amount_min = 1, amount_max = 15 },
            { itemstring = "mcl_core:diamond", weight = 2, amount_min = 1, amount_max = 5 },
            { itemstring = "mcl_core:coal_lump", weight = 12, amount_min = 1, amount_max = 19 },
            { itemstring = "mcl_core:stone_with_diamond", weight = 1, amount_min = 1, amount_max = 1 },
        }
    },
    {
        stacks_min = 2,
        stacks_max = 4,
        items = {
            { itemstring = "mcl_torches:torch", weight = 15, amount_min = 1, amount_max = 10 },
            { itemstring = "mcl_farming:bread", weight = 15, amount_min = 1, amount_max = 3 },
            { itemstring = "mcl_core:coal_lump", weight = 10, amount_min = 3, amount_max = 8 },
            { itemstring = "mcl_farming:beetroot_seeds", weight = 10, amount_min = 2, amount_max = 4 },
            { itemstring = "mcl_farming:melon_seeds", weight = 10, amount_min = 2, amount_max = 4 },
            { itemstring = "mcl_farming:pumpkin_seeds", weight = 10, amount_min = 2, amount_max = 4 },
            { itemstring = "mcl_core:iron_ingot", weight = 10, amount_min = 1, amount_max = 5 },
            { itemstring = "mcl_raw_ores:raw_iron", weight = 15, amount_min = 1, amount_max = 7 },
            { itemstring = "mcl_core:lapis", weight = 5, amount_min = 4, amount_max = 9 },
            { itemstring = "mcl_redstone:redstone", weight = 5, amount_min = 4, amount_max = 9 },
            { itemstring = "mcl_core:gold_ingot", weight = 5, amount_min = 1, amount_max = 3 },
            { itemstring = "mcl_core:diamond", weight = 3, amount_min = 1, amount_max = 2 },
            { itemstring = "mcl_core:stone", weight = 15, amount_min = 1, amount_max = 10 },
        }
    },
    {
        stacks_min = 3,
        stacks_max = 3,
        items = {
            { itemstring = "mcl_raw_ores:raw_iron", weight = 15, amount_min = 1, amount_max = 7 },
            { itemstring = "mcl_core:stone", weight = 15, amount_min = 1, amount_max = 10 },
            { itemstring = "mcl_minecarts:rail", weight = 20, amount_min = 4, amount_max = 8 },
            { itemstring = "mcl_torches:torch", weight = 15, amount_min = 1, amount_max = 16 },
            { itemstring = "mcl_minecarts:activator_rail", weight = 5, amount_min = 1, amount_max = 4 },
            { itemstring = "mcl_minecarts:detector_rail", weight = 5, amount_min = 1, amount_max = 4 },
            { itemstring = "mcl_minecarts:golden_rail", weight = 5, amount_min = 1, amount_max = 4 },
            { itemstring = "mcl_redstone:redstone", weight = 30, amount_min = 1, amount_max = 15 },
            { itemstring = "mcl_core:coal_lump", weight = 12, amount_min = 1, amount_max = 19 },
        }
    },
    -- non-MC loot: 50% chance to add a minecart, offered as alternative to spawning minecarts on rails.
    -- TODO: Remove this when minecarts spawn on rails.
    {
        stacks_min = 0,
        stacks_max = 2,
        items = {
            { itemstring = "mcl_torches:torch", weight = 15, amount_min = 1, amount_max = 10 },
            { itemstring = "mcl_minecarts:rail", weight = 10, amount_min = 4, amount_max = 8 },
            { itemstring = "mcl_minecarts:minecart", weight = 1 },
        }
    }
    }

    local items = mcl_loot.get_multi_loot(loottable, pr);

    return items;
end