local S = core.get_translator(core.get_current_modname());

core.register_craftitem("craftoplus:dough", {
    description = S("Dough"),
    _tt_help = S("You can bake a bread."),
    _doc_items_longdesc = S("Dough, you can bake a bread."),
    wield_image = "dough.png",
    inventory_image = "dough.png",
    groups = { craftitem = 1, },
    stack_max = 16,
})

core.register_craft({
    type = "shapeless",
    output = "craftoplus:dough",
    recipe = {"craftoplus:wheat_flour", "mcl_potions:water"},
    replacements = {{"mcl_potions:water", "mcl_potions:glass_bottle"}}
})


core.register_on_mods_loaded(function()
    core.clear_craft({
        type = "shapeless",
        output = "mcl_farming:bread",
        recipe = {"mcl_farming:wheat_item", "mcl_farming:wheat_item", "mcl_farming:wheat_item"}
    });
    
    core.register_craft({
        type = "cooking",
        recipe = "craftoplus:dough",
        output = "mcl_farming:bread 4",
        cooktime = 20
    })
end)