local S = core.get_translator(core.get_current_modname());

core.override_item("mcl_throwing:egg", {
    description = S("Egg"),
    _tt_help = S("Throwable").."\n"..S("Chance to hatch chicks when broken"),
    _doc_items_longdesc = S("Eggs can be thrown or launched from a dispenser and breaks on impact. There is a small chance that 1 or even 4 chicks will pop out of the egg."),
    _doc_items_usagehelp = S("Use the punch key to throw."),
    inventory_image = "mcl_throwing_egg.png",
    stack_max = 16,
    on_place = mcl_throwing.get_player_throw_function("mcl_throwing:egg_entity"),
    on_secondary_use = mcl_throwing.get_player_throw_function("mcl_throwing:egg_entity"),
    _on_dispense = mcl_throwing.dispense_function,
    _dispense_into_walkable = true,
    groups = { craftitem = 1, smoker_cookable = 1 },
})

core.register_craftitem("craftoplus:cooked_egg", {
    description = S("Cooked Egg"),
    _doc_items_longdesc = S("Cooked Egg."),
    inventory_image = "cooked_egg.png",
    on_place = core.item_eat(1),
    on_secondary_use = core.item_eat(1),
    groups = {food = 2, eatable = 1, compostability = 85},
    _mcl_saturation = 1.0,
})

core.register_craft({
    type = "cooking",
    recipe = "mcl_throwing:egg",
    output = "craftoplus:cooked_egg",
    cooktime = 5
})