local S = core.get_translator(core.get_current_modname());
local C = core.colorize;

local function drink_milk(itemstack, player, pointed_thing, container, milk, eat)
    if mcl_hunger.active or core.is_creative_enabled(player:get_player_name()) then
        mcl_hunger.stop_poison(player);
    end
    mcl_potions._reset_effects(player);
    craftoplus.eat_item(itemstack, player, pointed_thing, "survival_thirst_drink.ogg", eat, container);
    
    return itemstack;
end

-- BUCKET
core.override_item("mcl_mobitems:milk_bucket", {
    description = S("Milk"),
    _tt_help = C(mcl_colors.GREEN, S("Removes all status effects")),
    _doc_items_longdesc = S("Milk is very refreshing and can be obtained by using a bucket on a cow. Drinking it will remove all status effects."),
    _doc_items_usagehelp = S("Use the placement key to drink the milk."),
    inventory_image = "mcl_mobitems_bucket_milk.png",
    wield_image = "mcl_mobitems_bucket_milk.png",
    on_place = function(itemstack, player, pointed_thing)
        return drink_milk(
            itemstack, player, pointed_thing, 
            "mcl_buckets:bucket_empty", "mcl_mobitems:milk_bucket", 
            4
        );
    end,
    on_secondary_use = function(itemstack, player, pointed_thing)
        return drink_milk(
            itemstack, player, pointed_thing, 
            "mcl_buckets:bucket_empty", "mcl_mobitems:milk_bucket", 
            4
        );
    end,
    stack_max = 1,
    _mcl_saturation = 1.0,
    groups = { food = 3, eatable = 4, can_eat_when_full = 1 },
})

-- BOTTLE
core.register_craftitem("craftoplus:milk_bottle", {
    description = S("Milk Bottle"),
    _doc_items_longdesc = S("Milk is very refreshing and can be obtained by using a bottle on a cow."),
    _doc_items_usagehelp = S("Use the placement key to drink the milk. Drinking it will remove all status effects."),
    inventory_image = "mcl_milk_bottle.png",
    groups = { craftitem = 1, food = 3, eatable = 1, can_eat_when_full=1 },
    on_place = function(itemstack, player, pointed_thing)
        return drink_milk(
            itemstack, player, pointed_thing, 
            "mcl_potions:glass_bottle", "craftoplus:milk_bottle", 
            1
        );
    end,
    on_secondary_use = function(itemstack, player, pointed_thing)
        return drink_milk(
            itemstack, player, pointed_thing, 
            "mcl_potions:glass_bottle", "craftoplus:milk_bottle", 
            1
        );
    end,
    stack_max = 16,
    _mcl_saturation = 0.4,
})

core.register_craft({
    output = "craftoplus:milk_bottle 8",
    replacements = {{"mcl_mobitems:milk_bucket", "mcl_buckets:bucket_empty"}},
    recipe = {
        { "mcl_potions:glass_bottle", "mcl_potions:glass_bottle", "mcl_potions:glass_bottle"  },
        { "mcl_potions:glass_bottle", "mcl_mobitems:milk_bucket", "mcl_potions:glass_bottle"  },
        { "mcl_potions:glass_bottle", "mcl_potions:glass_bottle", "mcl_potions:glass_bottle"  }
    }
})


core.register_craft({
    output = "mcl_mobitems:milk_bucket",
    replacements = {
        {"craftoplus:milk_bottle", "mcl_potions:glass_bottle"},
        {"craftoplus:milk_bottle", "mcl_potions:glass_bottle"},
        {"craftoplus:milk_bottle", "mcl_potions:glass_bottle"},
        {"craftoplus:milk_bottle", "mcl_potions:glass_bottle"},
        {"craftoplus:milk_bottle", "mcl_potions:glass_bottle"},
        {"craftoplus:milk_bottle", "mcl_potions:glass_bottle"},
        {"craftoplus:milk_bottle", "mcl_potions:glass_bottle"},
        {"craftoplus:milk_bottle", "mcl_potions:glass_bottle"},
    },
    recipe = {
        { "craftoplus:milk_bottle", "craftoplus:milk_bottle", "craftoplus:milk_bottle"  },
        { "craftoplus:milk_bottle", "mcl_buckets:bucket_empty", "craftoplus:milk_bottle"  },
        { "craftoplus:milk_bottle", "craftoplus:milk_bottle", "craftoplus:milk_bottle"  }
    }
})