local S = core.get_translator(core.get_current_modname());

core.override_item("mcl_flowers:tallgrass", {
    description = S("Tall Grass"),
    drawtype = "plantlike",
    longdesc = S("Tall grass is a small plant which often occurs on the surface of grasslands. It can be harvested for wheat seeds. By using bone meal, tall grass can be turned into double tallgrass which is two blocks high."),
    _doc_items_usagehelp = mcl_flowers.plant_usage_help,
    _doc_items_hidden = false,
    waving = 1,
    tiles = {"mcl_flowers_tallgrass.png"},
    inventory_image = "mcl_flowers_tallgrass_inv.png",
    wield_image = "mcl_flowers_tallgrass_inv.png",
    selection_box = {
        type = "fixed",
        fixed = {{ -6/16, -8/16, -6/16, 6/16, 4/16, 6/16 }},
    },
    paramtype = "light",
    paramtype2 = "color",
    palette = "mcl_core_palette_grass.png",
    sunlight_propagates = true,
    walkable = false,
    buildable_to = true,
    groups = {
        handy = 1, shearsy = 1, attached_node = 1, deco_block = 1,
        plant = 1, place_flowerlike = 2, non_mycelium_plant = 1,
        flammable = 3, fire_encouragement = 60, fire_flammability = 10, dig_by_piston = 1,
        dig_by_water = 1, destroy_by_lava_flow = 1, compostability = 30, grass_palette = 1
    },
    sounds = mcl_sounds.node_sound_leaves_defaults(),
    drop = "",
    _mcl_shears_drop = true,
    node_placement_prediction = "",
    on_place = mcl_flowers.on_place_flower,
    _mcl_hardness = 0,
    _on_bone_meal = mcl_flowers.on_bone_meal,
})