-- UTILS
-- ------------------------------------------

-- ADD ITEM TO INVENTORY
function craftoplus.add_item_to_inventory(user, item_id)
    local inv = user:get_inventory();
    if inv:room_for_item("craftoplus", {name=item_id}) then
        inv:add_item("craftoplus", item_id);
    else
        local pos = user:get_pos();
        pos.y = math.floor(pos.y + 0.5);
        core.add_item(pos, item_id);
    end
end

-- EAT ITEM
function craftoplus.eat_item(itemstack, user, pointed_thing, sound, item_id, loot)
    core.sound_play(sound, {to_player = user:get_player_name(), gain = 0.7}, true);
    core.item_eat(item_id)(itemstack, user, pointed_thing);
    
    if loot ~= nil then
        craftoplus.add_item_to_inventory(user, loot);
    end
end

-- CAPITALIZE TEXT
function craftoplus.capitalize(str)
    return (str:gsub("^%l", string.upper));
end