local S = core.get_translator(core.get_current_modname());

local acorn_chances = {200, 180, 160, 120, 40};
local stick_chances = {50, 45, 30, 35, 10};
local sapling_chances = {20, 16, 12, 10};

local function get_drops(fortune_level, tree)
    local drop = {
        max_items = 1,
        items = {
            {
                items = {"mcl_core:stick 1"},
                rarity = stick_chances[fortune_level + 1]
            },
            {
                items = {"mcl_core:stick 2"},
                rarity = stick_chances[fortune_level + 1]
            },
            {
                items = {"mcl_trees:sapling_"..tree},
                rarity = sapling_chances[fortune_level + 1] or sapling_chances[fortune_level]
            },
            {
                items = {"craftoplus:acorn"},
                rarity = acorn_chances[fortune_level + 1]
            },
        }
    }
    
    return drop;
end

-- OAK TREE LEAVES
for i, tree in pairs({"oak", "dark_oak"}) do
    local oak_leaves_def = core.registered_nodes["mcl_trees:leaves_"..tree];

    core.override_item("mcl_trees:leaves_"..tree, {
        description = oak_leaves_def["description"],
        _doc_items_longdesc = oak_leaves_def["_doc_items_longdesc"],
        groups = oak_leaves_def["groups"],
        tiles = oak_leaves_def["tiles"],
        after_place_node = oak_leaves_def["after_place_node"],
        _mcl_leaves = oak_leaves_def["_mcl_leaves"],
        _mcl_orphan_leaves = oak_leaves_def["_mcl_orphan_leaves"],
        
        drop = get_drops(0, tree),
        _mcl_fortune_drop = {
            get_drops(1, tree), get_drops(2, tree), 
            get_drops(3, tree), get_drops(4, tree)
        },
        
        on_construct = oak_leaves_def["on_construct"],
        after_destruct = oak_leaves_def["after_destruct"],
        
        _doc_items_create_entry = oak_leaves_def["_doc_items_create_entry"],
        _mcl_shears_drop = oak_leaves_def["_mcl_shears_drop"],
        _mcl_silk_touch_drop = oak_leaves_def["_mcl_silk_touch_drop"],
    });
end


-- ACORN
core.register_craftitem("craftoplus:acorn", {
    description = S("Acorn"),
    _doc_items_longdesc = S("Acorn."),
    wield_image = "acorn.png",
    inventory_image = "acorn.png",
    groups = { craftitem = 1, },
    stack_max = 64,
})