local S = core.get_translator(core.get_current_modname());

copper_stages = {
    {name="Copper", id=""},
    {name="Exposed Copper", id="_exposed"},
    {name="Weathered Copper", id="_weathered"},
    {name="Oxidized Copper", id="_oxidized"},
};

core.register_craftitem("craftoplus:copper_nugget", {
    description = S("Copper Nugget"),
    _doc_items_longdesc = S("Copper nuggets are very small pieces of molten copper; the main purpose is to create copper ingots."),
    inventory_image = "mcl_copper_nugget.png",
    groups = { craftitem=1 },
    _mcl_crafting_output = {square3 = {output = "mcl_copper:copper_ingot"}}
})

core.register_craft({
    output = "craftoplus:copper_nugget 9",
    recipe = {
        { "mcl_copper:copper_ingot"  }
    }
})

core.register_craft({
    output = "mcl_copper:copper_ingot",
    recipe = {
        { "craftoplus:copper_nugget", "craftoplus:copper_nugget", "craftoplus:copper_nugget" },
        { "craftoplus:copper_nugget", "craftoplus:copper_nugget", "craftoplus:copper_nugget" },
        { "craftoplus:copper_nugget", "craftoplus:copper_nugget", "craftoplus:copper_nugget" }
    }
})


-- ABM
core.register_abm({
    label = "Node Oxidize",
    nodenames = {"group:can_oxid"},
    interval = 500,
    chance = 3,
    action = function(pos, node)
        local node_data = core.registered_nodes[node.name];
        core.swap_node(pos, {name = node_data.oxinode, param2 = node.param2});
    end,
})