local S = core.get_translator(core.get_current_modname());

-- STOOL
for i, wood in pairs(craftoplus.woods) do
    local oak_leaves_def = core.registered_nodes[craftoplus.wood_path..wood];
    local wood_texture = oak_leaves_def.tiles;
    if (type(wood_texture) == "table") then
        wood_texture = oak_leaves_def.tiles[1];
    end
    
    core.register_node("craftoplus:stool_"..wood, {
        description = S(craftoplus.to_name(wood, 1).." Wood Stool"),
        drawtype = "mesh",
        mesh = "stool.obj",
        tiles = {
            wood_texture,
            wood_texture.."^shadow_1.png",
            wood_texture.."^shadow_2.png",
        },
        selection_box = craftoplus.box(-0.3, -0.5, -0.3, 0.3, 0.05, 0.3),
        collision_box = craftoplus.box(-0.3, -0.5, -0.3, 0.3, 0.05, 0.3),
        paramtype = "light",
        on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
            return craftoplus.sit(pos, node, clicker, itemstack, pointed_thing, {x=0, y=0.3, z=0});
        end,
    });
    
    
end