local S = core.get_translator(core.get_current_modname());

-- HONEYCOMB
core.override_item("mcl_honey:honeycomb", {
    _dispense_into_walkable = true,
    _on_dispense = function(stack, _, droppos, dropnode)
        if not dropnode.name:find("_preserved") then
            local new_name = dropnode.name .. "_preserved"

            if core.registered_nodes[new_name] then
                mcl_copper.spawn_particles(droppos, "mcl_copper_anti_oxidation_particle.png^[colorize:#d1d553:125")
                core.swap_node(droppos, {name = new_name, param2 = dropnode.param2})
                stack:take_item()
            end
        end
        return stack
    end,
    description = S("Honeycomb"),
    _doc_items_longdesc = S("Used to craft beehives and protect copper blocks from further oxidation."),
    _doc_items_usagehelp = S("Use on copper blocks to prevent further oxidation."),
    inventory_image = "mcl_honey_honeycomb.png",
    groups = { craftitem = 1, preserves_copper = 1 },
    on_place = function(itemstack, placer, pointed_thing)
        local pos = pointed_thing.under;
        local node = core.get_node(pos);
        if not node.name:find("_preserved") then
            local new_name = node.name .. "_preserved"

            if core.registered_nodes[new_name] then
                mcl_copper.spawn_particles(pos, "mcl_copper_anti_oxidation_particle.png^[colorize:#d1d553:125")
                core.swap_node(pos, {name = new_name, param2 = node.param2})
                itemstack:take_item()
                awards.unlock(placer:get_player_name(), "mcl:wax_on");
            end
        end
        return itemstack;
    end,
    _mcl_crafting_output = {square2 = {output = "mcl_honey:honeycomb_block"}}
})