-- UTILS
-- ------------------------------------------

-- ADD ITEM TO INVENTORY
function craftoplus.add_item_to_inventory(user, item_id)
    local inv = user:get_inventory();
    if inv:room_for_item("craftoplus", {name=item_id}) then
        inv:add_item("craftoplus", item_id);
    else
        local pos = user:get_pos();
        pos.y = math.floor(pos.y + 0.5);
        core.add_item(pos, item_id);
    end
end

-- BOX
function craftoplus.box(p1, p2, p3, p4, p5, p6) -- (LEFT, BUTTOM, BACK, RIGHT, TOP, FRONT)
    return {type = "fixed", fixed = {{p1, p2, p3, p4, p5, p6}}};
end

-- EAT ITEM
function craftoplus.eat_item(itemstack, user, pointed_thing, sound, item_id, loot)
    core.sound_play(sound, {to_player = user:get_player_name(), gain = 0.7}, true);
    core.item_eat(item_id)(itemstack, user, pointed_thing);
    
    if loot ~= nil then
        craftoplus.add_item_to_inventory(user, loot);
    end
end

-- SPLIT
function craftoplus.split(str, sep)
    local result = {};
    if (sep == nil) then sep = "%s" end
    for str in string.gmatch(str, "([^"..sep.."]+)") do
        table.insert(result, str);
    end
    return result;
end

-- CAPITALIZE TEXT
function craftoplus.capitalize(str)
    return (str:gsub("^%l", string.upper));
end

-- TO NAME
function craftoplus.to_name(str, cap)
    local sp = craftoplus.split(str, "_");
    local result = "";
    local sep = "";
    for i, part in ipairs(sp) do
        if (i > 1) then sep = " "; end
        if (cap == 1) then
            result = result..sep..part:gsub("^%l", string.upper);
        else
            result = result..sep..part;
        end
    end
    return result;
end