local S = core.get_translator(core.get_current_modname());

for i, stage in pairs(copper_stages) do

    local oxinode = "mcl_lanterns:copper_lantern"..stage.id.."_floor";
    local can_oxid = 1;
    
    if i < #copper_stages then
        oxinode = "mcl_lanterns:copper_lantern"..copper_stages[i+1].id.."_floor" or oxinode;
    else
        can_oxid = 0;
    end;
    
    local name = stage.name;
    local node_id = "copper_lantern"..stage.id;

    for key, wax in pairs({"", "_preserved"}) do
        back_node_id = "";
        if (wax == "_preserved") then
            can_oxid = 0;
            name = "Waxed "..name;
            node_id = node_id.."_preserved";
            back_node_id = node_id;
        end;
    
        mcl_lanterns.register_lantern(node_id, {
            description = S(name.." Lantern"),
            longdesc = S("Lanterns are light sources which can be placed on the top or the bottom of most blocks."),
            texture = "mcl_copper_lantern"..stage.id..".png",
            texture_inv = "mcl_copper_lantern"..stage.id.."_inv.png",
            light_level = core.LIGHT_MAX-i,
            groups = {can_oxid=can_oxid},
        })
    end
    
end

core.register_craft({
    output = "mcl_lanterns:copper_lantern_floor",
    recipe = {
        {"craftoplus:copper_nugget", "craftoplus:copper_nugget", "craftoplus:copper_nugget"},
        {"craftoplus:copper_nugget", "mcl_torches:torch",        "craftoplus:copper_nugget"},
        {"craftoplus:copper_nugget", "craftoplus:copper_nugget", "craftoplus:copper_nugget"},
    },
});