local S = core.get_translator(core.get_current_modname());


-- COPPER SET
mcl_tools.register_set("copper", {
    craftable = true,
    material = "mcl_copper:copper_ingot",
    uses = 150,
    level = 3,
    speed = 9,
    max_drop_level = 3,
    groups = { dig_speed_class = 5, enchantability = 18 }
}, {
    ["pick"] = {
        description = S("Copper Pickaxe"),
        inventory_image = "default_tool_copperpick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 3 }
        }
    },
    ["shovel"] = {
        description = S("Copper Shovel"),
        inventory_image = "default_tool_coppershovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 3 }
        }
    },
    ["sword"] = {
        description = S("Copper Sword"),
        inventory_image = "default_tool_coppersword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 5 }
        }
    },
    ["axe"] = {
        description = S("Copper Axe"),
        inventory_image = "default_tool_copperaxe.png",
        tool_capabilities = {
            full_punch_interval = 1.05,
            damage_groups = { fleshy = 8 }
        }
    }
}, { _mcl_cooking_output = "craftoplus:copper_nugget" })


-- SCISSORS
local shears_longdesc = S("Shears are tools to shear sheep and to mine a few block types. Shears are a special mining tool and can be used to obtain the original item from grass, leaves and similar blocks that require cutting.")
local shears_use = S("To shear sheep or carve faceless pumpkins, use the “place” key on them. Faces can only be carved at the side of faceless pumpkins. Mining works as usual, but the drops are different for a few blocks.")

for key, shears in pairs({
    { name="Iron Scissors", id="shears", image="default_tool_shears.png", 
      material="mcl_core:iron_ingot", speed=5, uses=238 },
    { name="Copper Scissors", id="copper_shears", image="default_tool_coppershears.png", 
      material="mcl_copper:copper_ingot", speed=1.5, uses=150 },
}) do
    local data = {
        description = S(shears["name"]),
        _doc_items_longdesc = shears_longdesc,
        _doc_items_usagehelp = shears_use,
        inventory_image = shears["image"],
        wield_image = shears["image"],
        stack_max = 1,
        groups = { tool=1, shears=1, dig_speed_class=4, enchantability=-1, offhand_item=1 },
        tool_capabilities = {
            full_punch_interval = 0.5,
            max_drop_level=1,
        },
        on_place = mcl_tools.get_default_tool_place_func("shears"),
        sound = { breaks = "default_tool_breaks" },
        _mcl_toollike_wield = true,
        _mcl_diggroups = {
            shearsy = { speed = shears["speed"]*3, level = 1, uses = shears["uses"] },
            shearsy_wool = { speed = shears["speed"]*3, level = 1, uses = shears["uses"] },
            shearsy_cobweb = { speed = shears["speed"]*3, level = 1, uses = shears["uses"] }
        },
        _on_dispense = function(stack, _, droppos, dropnode, dropdir)
            if core.get_item_group(dropnode.name, "honey_level") == 5 then
                core.swap_node(droppos, {name = dropnode.name:gsub("_5", ""), param2 = dropnode.param2})
                core.add_item(vector.add(droppos, dropdir), "mcl_honey:honeycomb 3")
                stack:add_wear_by_uses(shears["uses"])
            end
            return stack
        end,
        _dispense_into_walkable = true,
        _mcl_uses = shears["uses"]
    };
    
    if (core.registered_nodes["mcl_tools:"..shears["id"]]) then
        core.override_item("mcl_tools:"..shears["id"], data);
    else
        core.register_tool("craftoplus:"..shears["id"], data);
    end

    core.register_craft({
        output = shears["id"],
        recipe = {
            { shears["material"], "" },
            { "", shears["material"], },
        }
    })
    core.register_craft({
        output = shears["id"],
        recipe = {
            { "", shears["material"], },
            { shears["material"], "" },
        }
    })
end

-- COPPER HOE --------
local hoe_common_defs = {
    longdesc = hoe_longdesc,
    usagehelp = hoe_usagehelp,
    groups = { hoe = 1, tool = 1 },
    diggroups = { hoey = {} },
    craft_shapes = {
        {
            { "material", "material" },
            { "mcl_core:stick", "" },
            { "mcl_core:stick", "" }
        },
        {
            { "material", "material" },
            { "", "mcl_core:stick" },
            { "", "mcl_core:stick" }
        }
    },
    _placement_def = {
        ["mcl_lush_caves:rooted_dirt"] = "default",
        ["mcl_core:dirt_with_grass"] = "default",
        ["mcl_core:grass_path"] = "default",
        ["mcl_core:dirt"] = "default",
        ["mcl_core:coarse_dirt"] = "default",
        inherit = "placeable_on_actionable",
    },
}

mcl_tools.add_to_sets("metal_hoe", hoe_common_defs, {
    ["copper"] = {
        description = S("Copper Hoe"),
        inventory_image = "farming_tool_copperhoe.png",
        tool_capabilities = {
            full_punch_interval = 0.5,
            damage_groups = { fleshy = 1, },
        },
        on_place = function (itemstack, placer, pointed_thing)
            local pos = pointed_thing.under;
            local cultivatable = core.get_item_group(core.get_node(pos).name, "cultivatable");
            if (cultivatable > 0) then
                mcl_farming.cultivate_soil(itemstack, placer, pointed_thing);
            end
        end,
        _mcl_cooking_output = "mcl_core:copper_nugget"
    },
}, {
    _tt_help = S("Turns dirt block into farmland"),
    tool_capabilities = { max_drop_level = 0 },
})