local S = core.get_translator(core.get_current_modname());

local sit_entities = {};

core.register_entity("craftoplus:seat_place", {
    initial_properties = {
        visual = "cube",
        textures = {"blank.png", "blank.png", "blank.png", "blank.png", "blank.png", "blank.png"},
        collisionbox = { -0.01, -0.01, -0.01, 0.01, 0.01, 0.01 },
        selectionbox = { -0.01, -0.01, -0.01, 0.01, 0.01, 0.01, rotate = false },
        static_save = false,
    },
    on_punch = function(self)
        self.object:remove()
    end,
})

-- SIT ON OBJECT
function craftoplus.sit(pos, node, clicker, itemstack, pointed_thing, sit_pos)
    if not clicker:is_player() then
        return itemstack
    end
    
    if (sit_entities[pos] == nil) then
        if (sit_pos == nil) then sit_pos = pos; end
        
        local attached_entity = clicker:get_attach() or nil;
        
        if (attached_entity ~= nil) then
            attached_entity:remove();
        else
            clicker:set_pos(pos);
        
            sit_entities[pos] = core.add_entity(pos, "craftoplus:seat_place");
            clicker:set_attach(sit_entities[pos], "", sit_pos, {x = 0, y = 0, z = 0}, true);
            mcl_player.player_set_animation(clicker, "sit", 30);
        end
    end
end

