local S = core.get_translator(core.get_current_modname());

local acorn_chances = {200, 180, 160, 120, 40};
local stick_chances = {50, 45, 30, 35, 10};
local sapling_chances = {20, 16, 12, 10};

local function get_drops(fortune_level, tree)
    local drop = {
        max_items = 1,
        items = {
            {
                items = {"mcl_core:stick 1"},
                rarity = stick_chances[fortune_level + 1]
            },
            {
                items = {"mcl_core:stick 2"},
                rarity = stick_chances[fortune_level + 1]
            },
            {
                items = {"mcl_trees:sapling_"..tree},
                rarity = sapling_chances[fortune_level + 1] or sapling_chances[fortune_level]
            },
            {
                items = {"craftoplus:acorn"},
                rarity = acorn_chances[fortune_level + 1]
            },
        }
    }
    
    return drop;
end

-- OAK TREE LEAVES
for i, tree in pairs({"oak", "dark_oak"}) do
    core.override_item("mcl_trees:leaves_"..tree, {
        drop = get_drops(0, tree),
        _mcl_fortune_drop = {
            get_drops(1, tree), get_drops(2, tree), 
            get_drops(3, tree), get_drops(4, tree)
        },
    });
end


-- ACORN
core.register_craftitem("craftoplus:acorn", {
    description = S("Acorn"),
    _doc_items_longdesc = S("Acorn."),
    wield_image = "acorn.png",
    inventory_image = "acorn.png",
    groups = { craftitem = 1, compostability = 10 },
    stack_max = 64,
})