local S = core.get_translator(core.get_current_modname());

--- Gold Door ---
mcl_doors:register_door("craftoplus:gold_door", {
    description = S("Gold Door"),
    _doc_items_longdesc = S("Golden doors are 2-block high barriers which can only be opened or closed by a redstone signal, and by hand."),
    inventory_image = "gold_door_item.png",
    groups = {pickaxey=1, gold=1, door_iron=1},
    _mcl_hardness = 4,
    tiles_bottom = {"gold_door_lower.png^[transformFX", "gold_door_side_lower.png"},
    tiles_top = {"gold_door_upper.png^[transformFX", "gold_door_side_upper.png"},
    sounds = mcl_sounds.node_sound_metal_defaults(),
    sound_open = "doors_steel_door_open",
    sound_close = "doors_steel_door_close",
})

core.register_craft({
    output = "craftoplus:gold_door 3",
    recipe = {
        {"mcl_core:gold_ingot", "mcl_core:gold_ingot"},
        {"mcl_core:gold_ingot", "mcl_core:gold_ingot"},
        {"mcl_core:gold_ingot", "mcl_core:gold_ingot"}
    }
})


--- Gold TrapDoor ---
mcl_doors:register_trapdoor("mcl_doors:gold_trapdoor", {
    description = S("Gold Trapdoor"),
    _doc_items_longdesc = S("Gold trapdoors are horizontal barriers which can be opened and closed by redstone signals, and by hand. They occupy the upper or lower part of a block, depending on how they have been placed. When open, they can be climbed like a ladder."),
    tile_front = "gold_trapdoor.png",
    tile_side = "gold_trapdoor_side.png",
    wield_image = "gold_trapdoor.png",
    groups = {pickaxey=1},
    _mcl_hardness = 4,
    sounds = mcl_sounds.node_sound_metal_defaults(),
    sound_open = "doors_steel_door_open",
    sound_close = "doors_steel_door_close",
})

core.register_craft({
    output = "mcl_doors:gold_trapdoor",
    recipe = {
        {"mcl_core:gold_ingot", "mcl_core:gold_ingot"},
        {"mcl_core:gold_ingot", "mcl_core:gold_ingot"},
    }
})