local S = core.get_translator(core.get_current_modname());

for i, type in pairs({"dark", "white", "milk"}) do
    core.register_craftitem("craftoplus:chocolate_"..type, {
        description = S(craftoplus.capitalize(type).." Chocolate"),
        _doc_items_longdesc = S("This is a food item which can be eaten."),
        inventory_image = "chocolate_"..type..".png",
        groups = {food = 2, eatable = 2, compostability = 85},
        _mcl_saturation = 0.4,
        on_place = core.item_eat(4),
        on_secondary_use = core.item_eat(4),
    })
end

core.register_craftitem("craftoplus:cocoa_oil", {
    description = S("Cocoa Oil"),
    _doc_items_longdesc = S("Place this item in an item frame as decoration."),
    wield_image = "cocoa_oil.png",
    inventory_image = "cocoa_oil.png",
    groups = { oil = 1 },
})

core.register_craft({
    output = "craftoplus:chocolate_dark",
    recipe = {
        {"mcl_cocoas:cocoa_beans", "mcl_cocoas:cocoa_beans"},
        {"mcl_cocoas:cocoa_beans", "mcl_core:sugar"},
    },
    replacements = {{"mcl_cocoas:cocoa_beans", "craftoplus:cocoa_oil"}}
})


core.register_craft({
    type = "shapeless",
    output = "craftoplus:chocolate_dark",
    recipe = {
        "mcl_cocoas:cocoa_beans", "mcl_cocoas:cocoa_beans",
        "mcl_cocoas:cocoa_beans", "mcl_core:sugar",
    },
    replacements = {{"mcl_cocoas:cocoa_beans", "craftoplus:cocoa_oil"}}
})

core.register_craft({
    output = "craftoplus:chocolate_white",
    recipe = {
        {"craftoplus:cocoa_oil", "craftoplus:cocoa_oil", "craftoplus:cocoa_oil"},
        {"craftoplus:cocoa_oil", "mcl_core:sugar", "craftoplus:cocoa_oil"},
        {"craftoplus:cocoa_oil", "craftoplus:cocoa_oil", "craftoplus:cocoa_oil"},
    }
})

core.register_craft({
    type = "shapeless",
    output = "craftoplus:chocolate_milk",
    recipe = {"craftoplus:chocolate_dark", "craftoplus:milk_bottle"}
})

core.register_craft({
    type = "shapeless",
    output = "craftoplus:chocolate_milk",
    recipe = {
        "mcl_cocoas:cocoa_beans", "mcl_cocoas:cocoa_beans",
        "mcl_cocoas:cocoa_beans", "mcl_core:sugar", 
        "craftoplus:milk_bottle",
    },
    replacements = {{"mcl_cocoas:cocoa_beans", "craftoplus:cocoa_oil"}}
})