local S = core.get_translator(core.get_current_modname());

local sel_heights = { 1/16,  2/16,  3/16, 8/16, 10/16, 13/16, 14/16, 15/16 }

-- GROW STEPS
for i=1, 7 do
    local create, name, longdesc
    if i == 1 then
        create = true
        name = S("Premature Wheat Plant")
        longdesc = S([[
            Premature wheat plants grow on farmland under sunlight in 8 stages.
            On hydrated farmland, they grow faster. They can be harvested at any time but will only yield a profit when mature.
        ]])
    else
        create = false
    end

    core.override_item("mcl_farming:wheat_"..i, {
        description = S("Premature Wheat Plant (Stage @1)", i),
        _doc_items_create_entry = create,
        _doc_items_entry_name = name,
        _doc_items_longdesc = longdesc,
        paramtype = "light",
        paramtype2 = "meshoptions",
        place_param2 = 3,
        visual_scale = 1.4,
        waving = 1,
        sunlight_propagates = true,
        walkable = false,
        drawtype = "plantlike",
        drop = "mcl_farming:wheat_seeds",
        tiles = {"wheat_texture_step"..(i-1)..".png"},
        inventory_image = "wheat_texture_step"..(i-1)..".png",
        wield_image = "wheat_texture_step"..(i-1)..".png",
        selection_box = {
            type = "fixed",
            fixed = {
                {-7/16, -0.5 ,-7/16, 7/16, sel_heights[i] ,7/16}
            },
        },
        groups = {dig_immediate=3, not_in_creative_inventory=1, plant=1,attached_node=1,
            dig_by_water=1,destroy_by_lava_flow=1, dig_by_piston=1, unsticky = 1},
        sounds = mcl_sounds.node_sound_leaves_defaults(),
        _mcl_hardness = 0,
        _on_bone_meal = on_bone_meal,
        _mcl_baseitem = "mcl_farming:wheat_seeds",
    })
end

-- HARVEST
core.override_item("mcl_farming:wheat", {
    description = S("Mature Wheat Plant"),
    _doc_items_longdesc = S([[
        Mature wheat plants are ready to be harvested for wheat and wheat seeds.
        They won't grow any further.
    ]]),
    sunlight_propagates = true,
    paramtype = "light",
    paramtype2 = "meshoptions",
    place_param2 = 3,
    visual_scale = 1.4,
    waving = 1,
    walkable = false,
    drawtype = "plantlike",
    tiles = {"wheat_texture_step7.png"},
    inventory_image = "wheat_texture_step7.png",
    wield_image = "wheat_texture_step7.png",
    drop = "mcl_farming:wheat_item",
    groups = {dig_immediate=3, not_in_creative_inventory=1, plant=1, attached_node=1,
        dig_by_water=1, destroy_by_lava_flow=1, dig_by_piston=1, unsticky = 1},
    sounds = mcl_sounds.node_sound_leaves_defaults(),
    selection_box = {
            type = "fixed",
            fixed = {
                {-7/16, -0.5 ,-7/16, 7/16, sel_heights[8] ,7/16}
            },
        },
    _mcl_hardness = 0,
});

-- CRAFT SEEDS
core.register_craft({
    output = "mcl_farming:wheat_seeds 3",
    recipe = {{"mcl_farming:wheat_item"}}
})


-- WHEAT FLOUR
core.register_craftitem("craftoplus:wheat_flour", {
    description = S("Wheat Flour"),
    _doc_items_longdesc = S("From wheat flour you can bake a bread, cakes, pies, and etc...,  can be made from wheat seeds."),
    inventory_image = "flour.png",
    groups = {flour=1, compostability=85},
})

-- CRAFT FLOUR
core.register_craft({
    output = "craftoplus:wheat_flour",
    recipe = {
        {"mcl_farming:wheat_seeds","mcl_farming:wheat_seeds","mcl_farming:wheat_seeds"},
        {"mcl_farming:wheat_seeds","mcl_farming:wheat_seeds","mcl_farming:wheat_seeds"},
        {"mcl_farming:wheat_seeds","mcl_farming:wheat_seeds","mcl_farming:wheat_seeds"},
    }
})