local S = core.get_translator(core.get_current_modname());

-- STOOL
for i, wood in pairs(craftoplus.woods) do
    local tree_def = core.registered_nodes[craftoplus.wood_path..wood];
    local wood_texture = tree_def.tiles;
    if (type(wood_texture) == "table") then
        wood_texture = tree_def.tiles[1];
    end
    
    core.register_node("craftoplus:stool_"..wood, {
        description = S(craftoplus.to_name(wood, 1).." Wood Stool"),
        drawtype = "mesh",
        mesh = "stool.obj",
        tiles = {
            wood_texture,
            wood_texture.."^shadow_1.png",
            wood_texture.."^shadow_2.png",
        },
        selection_box = craftoplus.box(-0.3, -0.5, -0.3, 0.3, 0.05, 0.3),
        collision_box = craftoplus.box(-0.3, -0.5, -0.3, 0.3, 0.05, 0.3),
        paramtype = "light",
        groups = {
		    handy = 1, flammable = 5, fire_encouragement = 30, fire_flammability = 60,
		    compostability = 30
	    },
        on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
            return craftoplus.sit(pos, node, clicker, itemstack, pointed_thing, {x=0, y=0.3, z=0});
        end,
        sounds = mcl_sounds.node_sound_wood_defaults(),
    });
    
    core.register_craft({
        output = "craftoplus:stool_"..wood,
        recipe = {
            {craftoplus.wood_path..wood, craftoplus.wood_path..wood},
            {"mcl_core:stick", "mcl_core:stick"},
        },
    })
    
end