local S = core.get_translator(core.get_current_modname());

local bucket_box = {
    type = "fixed",
    fixed = {-0.35, -0.5, -0.35, 0.35, 0.3, 0.35},
};

local def = {
    description = S("Bucket"),
    paramtype = "light",
    paramtype2 = "facedir",
    drawtype = "mesh",
    mesh = "bucket.obj",
    use_texture_alpha = "clip";
    selection_box = bucket_box,
    collision_box = bucket_box,
    on_place = craftoplus.place_item,
    groups = { dig_immediate=3 },
    sounds = craftoplus.sound_metal,
}

-- BUCKET EMPTY
local bucket_empty = table.copy(def);
bucket_empty.tiles = { "cfp_bucket_texture.png", "mcl_bucket.png", "cfp_empty.png" };
bucket_empty.drop = craftoplus.items.bucket_empty;

core.register_node("craftoplus:bucket_empty", bucket_empty);

-- BUCKET WITH WATER
local bucket_with_water = table.copy(def);
bucket_with_water.tiles = { "cfp_bucket_texture.png", "mcl_bucket.png", craftoplus.textures.water };
bucket_with_water.use_texture_alpha = "blend";
bucket_with_water.drop = craftoplus.items.bucket_water;

core.register_node("craftoplus:bucket_with_water", bucket_with_water);

-- BUCKET WITH LAVA
local bucket_with_lava = table.copy(def);
bucket_with_lava.description = S("Bucket with Lava");
bucket_with_lava.tiles = { "cfp_bucket_texture.png", "mcl_bucket.png", craftoplus.textures.lava };
bucket_with_lava.light_source = 7;
bucket_with_lava.drop = craftoplus.items.bucket_lava;

core.register_node("craftoplus:bucket_with_lava", bucket_with_lava);