local S = core.get_translator(core.get_current_modname());

local gold_ingot = craftoplus.items.gold_ingot;
local gold_nugget = craftoplus.items.gold_nugget;
local chain_box = { type = "fixed", fixed = { {-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625}} };

if gold_ingot and gold_nugget then
    core.register_node("craftoplus:gold_chain", {
        description = S("Gold Chain"),
        _doc_items_longdesc = S("Chains are gold metallic decoration blocks."),
        inventory_image = "cfp_gold_chain.png",
        tiles = {craftoplus.pref.."gold_chain_texture.png"},
        drawtype = "mesh",
        mesh = "chain.obj",
        paramtype = "light",
        paramtype2 = "facedir",
        use_texture_alpha = "clip",
        is_ground_content = false,
        sunlight_propagates = true,
        collision_box = chain_box,
        selection_box = chain_box,
        groups = { node=1, cracky=1, level=2  },
        sounds = craftoplus.sound_metal,
        on_place = function(itemstack, placer, pointed_thing)
            local on_rightclick = craftoplus.check_on_rightclick(itemstack, placer, pointed_thing);
            if on_rightclick then return on_rightclick; end;

            local p0 = pointed_thing.under;
            local p1 = pointed_thing.above;
            local param2 = 0;

            local placer_pos = placer:get_pos()
            if placer_pos then
                local dir = { x=p1.x-placer_pos.x, y=p1.y-placer_pos.y, z=p1.z-placer_pos.z };
                param2 = core.dir_to_facedir(dir);
            end

            if     p0.y - 1 == p1.y then param2 = 20
            elseif p0.x - 1 == p1.x then param2 = 16
            elseif p0.x + 1 == p1.x then param2 = 12
            elseif p0.z - 1 == p1.z then param2 = 8
            elseif p0.z + 1 == p1.z then param2 = 4
            end
                
            return core.item_place_node(itemstack, placer, pointed_thing, param2)
        end,
        _mcl_blast_resistance = 6,
        _mcl_hardness = 5,
    })
    
    if craftoplus.is_mineclonia() then
        core.override_item("craftoplus:gold_chain", {
            groups={ pickaxey=1, gold=1, deco_block=1, solid=1, },
        });
    end;

    core.register_craft({
        output = "craftoplus:gold_chain",
        recipe = {
            {gold_nugget},
            {gold_ingot},
            {gold_nugget},
        },
    })
end;