local S = core.get_translator(core.get_current_modname());

local node_box = { type="fixed", fixed={{-0.5, -0.5, 0, 0.5, 0, 0.5}} };
local first_node = nil;
local material = "";

for node_name, def in pairs(craftoplus.slabs) do
    local groups = table.copy(def.groups);
    
    material = string.sub(node_name, #craftoplus.slab_path+1);
    
    groups["slab"] = 0;
    groups["stair"] = 0;
    groups["block"] = 0;
    
    if not first_node then first_node = "craftoplus:plank_"..material; end;
    
    core.register_node("craftoplus:plank_"..material, {
        description = S(craftoplus.to_name(material).." Small Plank"),
        tiles = def.tiles,
        
        is_ground_content = false,
        paramtype = "light",
        paramtype2 = "facedir",
        
        groups = groups,
        
        drawtype = "nodebox",
        node_box = node_box,
        collision_box = node_box,
          
        on_place = function(itemstack, placer, pointed_thing)
            local on_rightclick = craftoplus.check_on_rightclick(itemstack, placer, pointed_thing);
            if on_rightclick then return on_rightclick; end;
            
            local p1 = pointed_thing.above;
            local param2 = 0

            if placer then
                local placer_pos = placer:get_pos()
                if placer_pos then
                    param2 = core.dir_to_facedir(vector.subtract(p1, placer_pos))
                end

                if craftoplus.is_pointing_above_middle(placer, pointed_thing) then
                    param2 = param2 + 20
                    if param2 == 21 then
                        param2 = 23
                    elseif param2 == 23 then
                        param2 = 21
                    end
                end
            end

            return core.item_place_node(itemstack, placer, pointed_thing, param2)
        end,
            
        sounds = def.sounds,
            
        _mcl_blast_resistance = def._mcl_blast_resistance,
        _mcl_burntime = def._mcl_burntime,
        _mcl_hardness = def._mcl_hardness,
    });
    
    core.register_craft({
        output = node_name,
        recipe = {
            {"craftoplus:plank_"..material, "craftoplus:plank_"..material}
        },
    });
    
    core.register_craft({
        output = string.gsub(node_name, "slab_", "stair_"),
        recipe = {
            {"", "craftoplus:plank_"..material},
            {"craftoplus:plank_"..material, "craftoplus:plank_"..material}
        },
    });
        
    local slab = craftoplus.slab_units[node_name] or {};
    if slab.block then
        core.register_craft({
            output = slab.block,
            recipe = {
                {"craftoplus:plank_"..material, "craftoplus:plank_"..material},
                {"craftoplus:plank_"..material, "craftoplus:plank_"..material}
            },
        });
        core.register_craft({
            output = "craftoplus:plank_"..material.." 8",
            recipe = {
                {slab.block, slab.block},
            },
        });
    end;
end;