local S = core.get_translator(core.get_current_modname());

local gold_ingot = craftoplus.items.gold_ingot;

local quantity = "";
if craftoplus.is_mineclonia() then quantity = " 3"; end;

for door, def in pairs({
    --[[gold_door = {
        description = S("Gold Door"),
    }, ]]
    carved_gold_door = {
        description = S("Carved Gold Door"),
        inventory_image = "cfp_gold_door_item.png",
        tiles = {{name = "mtg_doors_door_gold.png", backface_culling = true}},
        tiles_top = {"mcl_gold_door_upper.png^[transformFX", "mcl_gold_door_side_upper.png"},
        tiles_bottom = {"mcl_gold_door_lower.png^[transformFX", "mcl_gold_door_side_lower.png"},
        recipe = {
            {gold_ingot, gold_ingot},
            {gold_ingot, gold_ingot},
            {gold_ingot, gold_ingot}
        },
    },
}) do
    craftoplus.register_door("craftoplus:"..door, {
        description = def.description,
        _doc_items_longdesc = S("Golden doors are 2-block high barriers which can only be opened or closed by a redstone signal, and by hand."),
        inventory_image = def.inventory_image,
        tiles = def.tiles,
        tiles_top = def.tiles_top,
        tiles_bottom = def.tiles_bottom,
        groups = {},
        sounds = craftoplus.sound_metal,
        sound_open = "doors_steel_door_open",
        sound_close = "doors_steel_door_close",
        _mcl_hardness = 4,
    });
    
    if craftoplus.is_minetest() then
        core.override_item("craftoplus:"..door, {
            groups={ node=1, cracky=1, level=2, door=1 },
        });
    elseif craftoplus.is_mineclonia() then
        core.override_item("craftoplus:"..door, {
            groups={ pickaxey=1, gold=1, door_iron=1 },
        });
    end;
    
    if def.recipe then
        core.register_craft({
            output = "craftoplus:"..door..quantity,
            recipe = def.recipe,
        });
    end;
end;