local S = core.get_translator(core.get_current_modname());

local gold_ingot = craftoplus.items.gold_ingot;

local quantity = "";
if craftoplus.is_mineclonia() then quantity = " 3"; end;

for trapdoor, def in pairs({
    --[[gold_trapdoor = {
        description = S("Gold Trapdoor"),
    }, ]]
    carved_gold_trapdoor = {
        description = S("Carved Gold Trapdoor"),
        tile_front = "cfp_gold_trapdoor.png",
        tile_side = "cfp_gold_trapdoor_side.png",
        recipe = {
            {gold_ingot, gold_ingot},
            {gold_ingot, gold_ingot}
        },
    },
}) do
    craftoplus.register_trapdoor("craftoplus:"..trapdoor, {
        description = def.description,
        _doc_items_longdesc = S("Gold trapdoors are horizontal barriers which can be opened and closed by redstone signals, and by hand. They occupy the upper or lower part of a block, depending on how they have been placed. When open, they can be climbed like a ladder."),
        tile_front = def.tile_front,
        tile_side = def.tile_side,
        groups = {},
        sounds = craftoplus.sound_metal,
        sound_open = "doors_steel_door_open",
        sound_close = "doors_steel_door_close",
        gain_open = 0.2,
        gain_close = 0.2,
        _mcl_hardness = 4,
    });
    
    if craftoplus.is_minetest() then
        core.override_item("craftoplus:"..trapdoor, {
            groups={ node=1, cracky=1, level=2, door=1 },
        });
    elseif craftoplus.is_mineclonia() then
        core.override_item("craftoplus:"..trapdoor, {
            groups={ pickaxey=1, gold=1, door_iron=1 },
        });
    end;
    
    if def.recipe then
        core.register_craft({
            output = "craftoplus:"..trapdoor..quantity,
            recipe = def.recipe,
        });
    end;
end;