local S = core.get_translator(core.get_current_modname());

local cocoa_beans = craftoplus.items.cocoa_beans;
local sugar = craftoplus.items.sugar;
local milk = craftoplus.items.milk_bottle;

if cocoa_beans and sugar then
    for i, type in pairs({"dark", "white", "milk"}) do
        core.register_craftitem("craftoplus:chocolate_"..type, {
            description = S(craftoplus.to_name(type).." Chocolate"),
            _doc_items_longdesc = S("This is a food item which can be eaten."),
            inventory_image = craftoplus.pref.."chocolate_"..type..".png",
            groups = { food=2, eatable=2, compostability=85 },
            _mcl_saturation = 0.4,
            on_place = core.item_eat(4),
            on_secondary_use = core.item_eat(4),
        })
    end;
    
    local cocoa_oil = "craftoplus:cocoa_oil";
    core.register_craftitem(cocoa_oil, {
        description = S("Cocoa Oil"),
        _doc_items_longdesc = S("Place this item in an item frame as decoration."),
        wield_image = craftoplus.pref.."cocoa_oil.png",
        inventory_image = craftoplus.pref.."cocoa_oil.png",
        groups = { oil=1 },
    });
    
    core.register_craft({
        type = "shapeless",
        output = "craftoplus:chocolate_dark",
        recipe = { cocoa_beans, cocoa_beans, cocoa_beans, sugar },
        replacements = {{"mcl_cocoas:cocoa_beans", cocoa_oil}}
    })

    core.register_craft({
        output = "craftoplus:chocolate_white",
        recipe = {
            {cocoa_oil, cocoa_oil, cocoa_oil},
            {cocoa_oil, sugar,     cocoa_oil},
            {cocoa_oil, cocoa_oil, cocoa_oil},
        }
    })

    core.register_craft({
        type = "shapeless",
        output = "craftoplus:chocolate_milk",
        recipe = {"craftoplus:chocolate_dark", "craftoplus:milk_bottle"}
    })

    core.register_craft({
        type = "shapeless",
        output = "craftoplus:chocolate_milk",
        recipe = {
            cocoa_beans, cocoa_beans, cocoa_beans, sugar,
            milk,
        },
        replacements = {{"mcl_cocoas:cocoa_beans", "craftoplus:cocoa_oil"}}
    })
end;
