local S = core.get_translator(core.get_current_modname());

local wheat_seeds = nil;
local flour = nil;

-- FLOUR
if core.registered_nodes["farming:flour"] then -- Minetest Game
    flour = "farming:flour";
end;

-- WHEAT SEEDS
if core.registered_nodes["farming:wheat"] then -- Minetest Game
    wheat_seeds = "farming:wheat";
elseif core.registered_nodes["mcl_farming:wheat_seeds"] then -- MineClonia
    wheat_seeds = "mcl_farming:wheat_seeds";
end;

-- WHEAT FLOUR
if (flour == nil) and wheat_seeds then
    flour = "craftoplus:wheat_flour";
    core.register_craftitem(flour, {
        description = S("Wheat Flour"),
        _doc_items_longdesc = S("From wheat flour you can bake a bread, cakes, pies, and etc...,  can be made from wheat seeds."),
        inventory_image = craftoplus.pref.."flour.png",
        groups = { flour=1, compostability=85 },
    });
end;

-- CRAFT FLOUR
if flour and wheat_seeds then
    core.clear_craft({ output=flour });
    core.register_craft({
        output = flour,
        recipe = {
            {wheat_seeds, wheat_seeds, wheat_seeds},
            {wheat_seeds, wheat_seeds, wheat_seeds},
            {wheat_seeds, wheat_seeds, wheat_seeds},
        }
    })
end;