-- SLAB UNITS
if craftoplus.is_minetest() then -- IF MINETEST
    craftoplus.slab_path = "stairs:slab_";
    
    for i, name in pairs({
        "glass", "obsidian_glass", "obsidian_glass", "stone", "cobble",
        "mossycobble", "stonebrick", "stone_block", "desert_stone",
        "desert_cobble", "desert_stonebrick", "desert_stone_block",
        "sandstone", "sandstonebrick", "sandstone_block", "desert_sandstone",
        "desert_sandstone_brick", "desert_sandstone_block", "silver_sandstone",
        "silver_sandstone_brick", "silver_sandstone_block", "obsidian",
        "obsidianbrick", "obsidian_block", "brick", "steelblock", "tinblock",
        "copperblock", "bronzeblock", "goldblock", "ice", "snowblock",
    }) do
        craftoplus.slab_units["stairs:slab_"..name] = { block="default:"..name };
    end;
    
    for wood, wood_id in pairs(craftoplus.woods) do
        craftoplus.slab_units["stairs:slab_"..wood] = {
            block=wood_id,
        };
        if core.registered_items[wood_id.."_bark"] then
            craftoplus.slab_units["stairs:slab_"..wood.."_bark"] = {
                block=wood_id.."_bark",
            };
        end;
    end;

elseif craftoplus.is_mineclonia() then -- IF MINECLONIA
    craftoplus.slab_path = "mcl_stairs:slab_";
    
    craftoplus.slab_units = {
        ["mcl_stairs:slab_stone"]               = {block="mcl_core:stone"},
        ["mcl_stairs:slab_brick_block"]         = {block="mcl_core:brick_block"},
        ["mcl_stairs:slab_oak_bark"]            = {block="mcl_trees:bark_oak"},
        ["mcl_stairs:slab_concrete_grey"]       = {block="mcl_colorblocks:concrete_grey",},
        ["mcl_stairs:slab_stonebrick"]          = {block="mcl_core:stonebrick"},
        ["mcl_stairs:slab_mud_brick"]           = {block="mcl_mud:mud_bricks"},
        ["mcl_stairs:slab_tuff_polished"]       = {block="mcl_deepslate:tuff_polished"},
        ["mcl_stairs:slab_tuff_bricks"]         = {block="mcl_deepslate:tuff_bricks"},
        ["mcl_stairs:slab_prismarine_dark"]     = {block="mcl_ocean:prismarine_dark"},
        ["mcl_stairs:slab_granite"]             = {block="mcl_core:granite"},
        ["mcl_stairs:slab_deepslate_polished"]  = {block="mcl_deepslate:deepslate_polished",},
        ["mcl_stairs:slab_end_bricks"]          = {block="mcl_end:end_bricks"},
        ["mcl_stairs:slab_deepslate_bricks"]    = {block="mcl_deepslate:deepslate_bricks"},
        ["mcl_stairs:slab_andesite"]            = {block="mcl_core:andesite"},
        ["mcl_stairs:slab_mossycobble"]         = {block="mcl_core:mossycobble"},
        ["mcl_stairs:slab_sandstonesmooth2"]    = {block="mcl_core:sandstonesmooth2"},
        ["mcl_stairs:slab_blackstone"]          = {block="mcl_blackstone:blackstone"},
        ["mcl_stairs:slab_quartz_smooth"]       = {block="mcl_nether:quartz_smooth"},
        ["mcl_stairs:slab_blackstone_polished"] = {block="mcl_blackstone:blackstone_polished"},
        ["mcl_stairs:slab_deepslate_bricks_cracked"] = {
            block="mcl_deepslate:deepslate_bricks_cracked"
        },
        ["mcl_stairs:slab_end_stone"]           = {block="mcl_end:end_stone"},
        ["mcl_stairs:slab_hardened_clay"]       = {block="mcl_colorblocks:hardened_clay"},
        ["mcl_stairs:slab_copper_exposed_cut_preserved"] = {
            block="mcl_copper:block_exposed_cut_preserved"
        },
        ["mcl_stairs:slab_copper_cut"]          = {block="mcl_copper:block_cut"},
        ["mcl_stairs:slab_quartzblock"]         = {block="mcl_nether:quartz_block"},
        ["mcl_stairs:slab_purpur_block"]        = {block="mcl_end:purpur_block"},
        ["mcl_stairs:slab_copper_weathered_cut"] = {
            block="mcl_copper:block_weathered_cut"
        },
        ["mcl_stairs:slab_nether_brick"]        = {block="mcl_nether:nether_brick"},
        ["mcl_stairs:slab_deepslate_cobbled"]   = {block="mcl_deepslate:deepslate_cobbled"},
        ["mcl_stairs:slab_copper_oxidized_cut"] = {block="mcl_copper:block_oxidized_cut"},
        ["mcl_stairs:slab_prismarine"]          = {block="mcl_ocean:prismarine"},
        ["mcl_stairs:slab_prismarine_brick"]    = {block="mcl_ocean:prismarine_brick"},
        ["mcl_stairs:slab_blackstone_brick_polished"] = {
            block="mcl_blackstone:blackstone_brick_polished"
        },
        ["mcl_stairs:slab_copper_oxidized_cut_preserved"] = {
            block="mcl_copper:block_oxidized_cut_preserved"
        },
        ["mcl_stairs:slab_andesite_smooth"]     = {block="mcl_core:andesite_smooth"},
        ["mcl_stairs:slab_granite_smooth"]      = {block="mcl_core:granite_smooth"},
        ["mcl_stairs:slab_diorite_smooth"]      = {block="mcl_core:diorite_smooth"},
        ["mcl_stairs:slab_stonebrickmossy"]     = {block="mcl_core:stonebrickmossy"},
        ["mcl_stairs:slab_lapisblock"]          = {block="mcl_core:lapisblock"},
        ["mcl_stairs:slab_goldblock"]           = {block="mcl_core:goldblock"},
        ["mcl_stairs:slab_ironblock"]           = {block="mcl_core:ironblock"},
        ["mcl_stairs:slab_stonebrickcracked"]   = {block="mcl_core:stonebrickcracked"},
        ["mcl_stairs:slab_deepslate_tiles_cracked"] = {
            block="mcl_deepslate:deepslate_tiles_cracked"
        },
        ["mcl_stairs:slab_sandstonesmooth"]     = {block="mcl_core:sandstonesmooth"},
        ["mcl_stairs:slab_deepslate_tiles"]     = {block="mcl_deepslate:deepslate_tiles"},
        ["mcl_stairs:slab_redsandstonesmooth"]  = {block="mcl_core:redsandstonesmooth"},
        ["mcl_stairs:slab_sandstone"]           = {block="mcl_core:sandstone"},
        ["mcl_stairs:slab_cobble"]              = {block="mcl_core:cobble"},
        ["mcl_stairs:slab_diorite"]             = {block="mcl_core:diorite"},
        ["mcl_stairs:slab_red_nether_brick"]    = {block="mcl_nether:red_nether_brick"},
        ["mcl_stairs:slab_redsandstone"]        = {block="mcl_core:redsandstone"},
        ["mcl_stairs:slab_redsandstonesmooth2"] = {block="mcl_core:redsandstonesmooth2"},
        ["mcl_stairs:slab_stone_rough"]         = {block="mcl_core:stone"},
        ["mcl_stairs:slab_bamboo_mosaic"]       = {
            group="wood", 
            block="mcl_bamboo:bamboo_mosaic"
        },
        ["mcl_stairs:slab_copper_exposed_cut"]  = {
            block="mcl_copper:block_exposed_cut"
        },
        ["mcl_stairs:slab_copper_cut_preserved"] = {
            block="mcl_copper:block_cut_preserved"},
        ["mcl_stairs:slab_copper_weathered_cut_preserved"] = {
            block="mcl_copper:block_copper_weathered_cut_preserved"},
    };

    for color, colordef in pairs(mcl_dyes.colors) do
        craftoplus.slab_units["mcl_stairs:slab_concrete_"..color] = {
            block="mcl_colorblocks:concrete_"..color,
        };
        craftoplus.slab_units["mcl_stairs:slab_hardened_clay_"..color] = {
            block="mcl_colorblocks:hardened_clay_"..color,
        };
    end;

    for wood, wood_id in pairs(craftoplus.woods) do
        craftoplus.slab_units["mcl_stairs:slab_"..wood] = {
            block=wood_id,
        };
        if core.registered_items[wood_id.."_bark"] then
            craftoplus.slab_units["mcl_stairs:slab_"..wood.."_bark"] = {
                block=wood_id.."_bark",
            };
        end;
    end;
end;
