local S = core.get_translator(core.get_current_modname());
local F = core.formspec_escape;

local basic_wood = "wood";
if craftoplus.is_mineclonia() then basic_wood = "oak"; end;

for wood, wood_id in pairs(craftoplus.woods) do
    core.register_node("craftoplus:cabinet_"..wood, {
        description = S(craftoplus.to_name(wood).." Cabinet"),
        _tt_help = S("18 inventory slots"),
        _doc_items_longdesc = S("Cabinet are containers which provide 18 inventory slots."),
        _doc_items_usagehelp = S("To access its inventory, rightclick it. When broken, the items will drop out."),
        _doc_items_create_entry = wood == basic_wood,
        is_ground_content = false,
        drawtype = "nodebox",
        node_box = {
            type = "fixed",
            fixed = {-0.5, -0.5, 0, 0.5, 0.5, 0.5},
        },
        tiles = {
            "cfp_wood_top.png", "cfp_wood_bottom.png", "cfp_wood_side.png",
            "cfp_wood_side.png", "cfp_wood_side.png", "cfp_cabinet.png"
        },
        color = craftoplus.wood_colors[wood],
        paramtype = "light",
        paramtype2 = "facedir",
        on_construct = function(pos)
            craftoplus.set_inventory(pos, "main", craftoplus.stack_x * 2);
        end,
        after_dig_node = function(pos, oldnode, oldmetadata, digger)
            craftoplus.node_drop_items(pos);
        end,
        on_destruct = function(pos) craftoplus.node_drop_items(pos); end,
        on_rightclick = function(pos, node, clicker)
            craftoplus.inventory_formspec(
                clicker, "craftoplus:cabinet", "Cabinet",
                "main", pos, craftoplus.stack_x, 2
            );
        end,
        groups = { deco_block=1, unmovable_by_piston=1, choppy=2, oddly_breakable_by_hand=2, },
        sounds = craftoplus.sound_wood,
        _mcl_hardness = 2.5,
        _mcl_burntime = 15
    })
end

-- CRAFT RECIPE
core.register_craft({
    output = "craftoplus:cabinet_oak",
    recipe = {
        { "group:wood_slab", "group:wood_slab", "group:wood_slab" },
        { "group:wood_slab", "",                "group:wood_slab" },
        { "group:wood_slab", "group:wood_slab", "group:wood_slab" },
    }
})

local function recipe_craft(itemstack, player, old_craft_grid, craft_inv)
    if itemstack:get_name() ~= "craftoplus:cabinet_oak" then return end
    
    local prw_item = "";
    
    for i, item in pairs(old_craft_grid) do
        if (item:get_name() ~= "") then
            if (prw_item == "") then prw_item = item:get_name() end
            if (prw_item ~= item:get_name()) then return end
        end
    end
    
    if core.registered_nodes["craftoplus:cabinet_"..string.sub(prw_item, 17)] then
        return ItemStack("craftoplus:cabinet_"..string.sub(prw_item, 17));
    end
    
    return itemstack
end

core.register_craft_predict(recipe_craft);
core.register_on_craft(recipe_craft);