local S = core.get_translator(core.get_current_modname());

local torch = craftoplus.items.torch;
local gold_nugget = craftoplus.items.gold_nugget;

if torch and gold_nugget then

    if core.get_modpath("mcl_lanterns") then
        mcl_lanterns.register_lantern("gold_lantern", {
            description = S("Gold Lantern"),
            longdesc = S(
                "Lanterns are light sources which can be "..
                "placed on the top or the bottom of most blocks."
            ),
            texture = "mcl_gold_lantern.png",
            texture_inv = "mcl_gold_lantern_inv.png",
            light_level = core.LIGHT_MAX,
        })

        core.register_craft({
            output = "mcl_lanterns:gold_lantern_floor",
            recipe = {
                {gold_nugget, gold_nugget, gold_nugget},
                {gold_nugget, torch,       gold_nugget},
                {gold_nugget, gold_nugget, gold_nugget},
            },
        });
    end;
    
end;