local S = core.get_translator(core.get_current_modname());

local node_box = {
    type = "fixed",
    fixed = {-0.3, -0.5, -0.3, 0.3, 0.05, 0.3},
};

for wood, wood_id in pairs(craftoplus.woods) do
    local wood_def = core.registered_nodes[wood_id];
    local groups = {};
        
    if (wood_def) then
        local wood_texture = wood_def.tiles;
        if (type(wood_texture) == "table") then
            wood_texture = wood_def.tiles[1];
        end
        
        if craftoplus.is_minetest() then
            groups = { dig_immediate=3, };
        elseif craftoplus.is_mineclonia() then
            groups = { 
                handy=1, flammable=5, fire_encouragement=30, 
                fire_flammability=60, compostability=30,
            };
        end;
            
        core.register_node("craftoplus:stool_"..wood, {
            description = S(craftoplus.to_name(wood).." Wood Stool"),
            drawtype = "mesh",
            mesh = "stool.obj",
            tiles = {
                wood_texture,
                wood_texture.."^shadow_1.png",
                wood_texture.."^shadow_2.png",
            },
            selection_box = node_box,
            collision_box = node_box,
            paramtype = "light",
            groups = groups,
            on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
                return craftoplus.sit(pos, node, clicker, itemstack, pointed_thing, {x=0, y=0.3, z=0});
            end,
            sounds = craftoplus.sound_wood,
        });
        
        core.register_craft({
            output = "craftoplus:stool_"..wood,
            recipe = {
                {wood_id, wood_id},
                {craftoplus.stick, craftoplus.stick},
            },
        })
    end
end