local S = core.get_translator(core.get_current_modname());

local egg = craftoplus.items.egg;

if egg then
    core.override_item(egg, {
        groups = { craftitem = 1, smoker_cookable = 1 },
    })

    core.register_craftitem("craftoplus:cooked_egg", {
        description = S("Cooked Egg"),
        _doc_items_longdesc = S("Cooked Egg."),
        inventory_image = craftoplus.pref.."cooked_egg.png",
        on_place = core.item_eat(1),
        on_secondary_use = core.item_eat(1),
        groups = { food=2, eatable=1, compostability=85 },
        _mcl_saturation = 1.0,
    });

    core.register_craft({
        type = "cooking",
        recipe = egg,
        output = "craftoplus:cooked_egg",
        cooktime = 5
    });
end;
