local S = core.get_translator(core.get_current_modname());

local pie_fillings = {};

local apple = craftoplus.items.apple;
local sugar = craftoplus.items.sugar;
local pumpkin = craftoplus.items.pumpkin;
local sweet_berry = craftoplus.items.sweet_berry;
local egg = craftoplus.items.egg;

local dough = "craftoplus:dough_crust_form";

-- APPLE
if apple and sugar then
    pie_fillings.apple = {
        id = apple,
        recipe = {
            {apple, apple, apple},
            {apple, apple, apple},
            {sugar, dough, sugar},
        },
    };
end;

-- PUMPKIN
if pumpkin and sugar then
    pie_fillings.pumpkin = {
        id = pumpkin,
        pie_piece = "mcl_farming:pumpkin_pie",
        recipe = {
            {egg, pumpkin, egg},
            {sugar, dough, sugar},
        },
    };
end;

-- SWEET BERRY
if sweet_berry and sugar then
    pie_fillings.sweet_berry = {
        id = sweet_berry,
        recipe = {
            {sweet_berry, sweet_berry, sweet_berry},
            {sweet_berry, sweet_berry, sweet_berry},
            {sugar, dough, sugar},
        }
    };
end;

-- ---------------------------------------------

-- PIES
if (pie_fillings ~= {}) then
    for filling, def in pairs(pie_fillings) do
        local pref = def.pref or craftoplus.pref or "cfp_";

        -- MAKE PIE
        core.register_craftitem("craftoplus:pie_"..filling.."_raw", {
            description = S("Raw "..craftoplus.to_name(filling).." Pie"),
            _tt_help = S("You need to bake it before eat."),
            wield_image = pref.."pie_"..filling..".png^"..pref.."dough_crust_form_mask.png",
            inventory_image = pref.."pie_"..filling..".png^"..pref.."dough_crust_form_mask.png",
            groups = { craftitem=1, },
            stack_max = 16,
        })
        
        core.register_craft({
            output = "craftoplus:pie_"..filling.."_raw",
            recipe = def.recipe,
        });
        
        -- BAKE PIE
        core.register_craftitem("craftoplus:pie_"..filling, {
            description = S(craftoplus.to_name(filling).." Pie"),
            inventory_image = pref.."pie_"..filling..".png",
            wield_image = pref.."pie_"..filling..".png",
            on_place = core.item_eat(7),
            on_secondary_use = core.item_eat(7),
            groups = { food=2, eatable=7, compostability=85 },
            _mcl_saturation = 5.2,
            stack_max = 16,
        })

        core.register_craft({
            type = "cooking",
            recipe = "craftoplus:pie_"..filling.."_raw",
            output = "craftoplus:pie_"..filling,
            cooktime = 15
        })
        
        -- -------------------------
        
        -- PIE PIECE
        local pie_piece = def.pie_piece or "craftoplus:pie_"..filling.."_piece";
        
        local pie_piece_def = {
            description = S(craftoplus.to_name(filling).." Pie Piece"),
            _doc_items_longdesc = S("A "..filling.." pie is a tasty food item which can be eaten."),
            inventory_image = pref.."pie_"..filling.."_piece.png",
            wield_image = pref.."pie_"..filling.."_piece.png",
            on_place = core.item_eat(2),
            on_secondary_use = core.item_eat(2),
            groups = {food = 2, eatable = 2, compostability = 100},
            _mcl_saturation = 1.4,
        };
        
        if def.pie_piece then
            core.clear_craft({ output=def.pie_piece });
            core.override_item(def.pie_piece, pie_piece_def);
        else
            core.register_craftitem(pie_piece, pie_piece_def);
        end
        
        core.register_craft({
            type = "shapeless",
            output = pie_piece.." 4",
            recipe = {"craftoplus:pie_"..filling},
        });
        
        core.register_craft({
            output = "craftoplus:pie_"..filling,
            recipe = {
                {pie_piece, pie_piece},
                {pie_piece, pie_piece},
            },
        });
        
    end;
end;
