local S = core.get_translator(core.get_current_modname());
local C = core.colorize;

local empty_bucket = craftoplus.items.empty_bucket;
local milk_bucket = craftoplus.items.milk_bucket;
local glass_bottle = craftoplus.items.glass_bottle;

local milk_bottle = "craftoplus:milk_bottle";
craftoplus.items.milk_bottle = milk_bottle;

if empty_bucket and milk_bucket and glass_bottle then
    -- MILK BOTTLE
    core.register_craftitem(milk_bottle, {
        description = S("Milk Bottle"),
        _doc_items_longdesc = S("Milk is very refreshing and can be obtained by using a bottle on a cow."),
        _doc_items_usagehelp = S("Use the placement key to drink the milk. Drinking it will remove all status effects."),
        inventory_image = craftoplus.pref.."milk_bottle.png",
        groups = { craftitem=1, food=3, eatable=1, can_eat_when_full=1 },
        on_place = function(itemstack, player, pointed_thing)
            return drink_milk(
                itemstack, player, pointed_thing, 
                glass_bottle, milk_bottle, 
                1
            );
        end,
        stack_max = 16,
        _mcl_saturation = 0.4,
    })

    core.register_craft({
        output = "craftoplus:milk_bottle 8",
        replacements = {{milk_bucket, empty_bucket}},
        recipe = {
            { glass_bottle, glass_bottle, glass_bottle  },
            { glass_bottle, milk_bucket, glass_bottle  },
            { glass_bottle, glass_bottle, glass_bottle  }
        }
    })

    core.register_craft({
        output = milk_bucket,
        replacements = {
            {milk_bottle, glass_bottle},
            {milk_bottle, glass_bottle},
            {milk_bottle, glass_bottle},
            {milk_bottle, glass_bottle},
            {milk_bottle, glass_bottle},
            {milk_bottle, glass_bottle},
            {milk_bottle, glass_bottle},
            {milk_bottle, glass_bottle},
        },
        recipe = {
            { milk_bottle, milk_bottle, milk_bottle  },
            { milk_bottle, empty_bucket, milk_bottle  },
            { milk_bottle, milk_bottle, milk_bottle  }
        }
    })
end;