if craftoplus.is_minetest() then

    -- MINETEST - CHEST
    function default.chest.get_chest_formspec(pos)
        return craftoplus.inventory_formspec(nil, nil, "Chest", "main", pos, 8, 4, true);
    end;
    
    -- MINETEST - TRAPDOORS
    for i, trapdoor in pairs({ 
        "doors:trapdoor", "doors:trapdoor_steel", 
        "xpanes:trapdoor_steel_bar",
    }) do
        core.override_item(trapdoor, { inventory_image="", });
    end;
    
    -- MINETEST - BUCKET EMPTY
    core.override_item("bucket:bucket_empty", {
        inventory_image="mtg_bucket.png",
        --[[NEED_TO_FIX on_place = function(itemstack, placer, pointed_thing)
            craftoplus.place_switched_item(
                "craftoplus:bucket_empty", 
                itemstack, placer, pointed_thing
            );
        end;]]
    });
    
    -- MINETEST - BUCKET WATER
    core.override_item("bucket:bucket_water", {
        inventory_image="mtg_bucket.png^mtg_bucket_with_water.png",
    });
    
    -- MINETEST - BUCKET RIVER WATER
    core.override_item("bucket:bucket_river_water", {
        inventory_image="mtg_bucket.png^mtg_bucket_with_river_water.png",
    });
    
    -- MINETEST - BUCKET LAVA
    core.override_item("bucket:bucket_lava", {
        inventory_image="mtg_bucket.png^mtg_bucket_with_lava.png",
        --[[NEED_TO_FIX on_place = function(itemstack, placer, pointed_thing)
            craftoplus.place_switched_item(
                "craftoplus:bucket_with_lava", 
                itemstack, placer, pointed_thing
            );
        end,]]
    });
    
elseif craftoplus.is_mineclonia() then

    
    -- MINECLONIA - BUCKET EMPTY
    core.override_item("mcl_buckets:bucket_empty", {
        inventory_image="mcl_bucket.png",
        --[[NEED_TO_FIX on_place = function(itemstack, placer, pointed_thing)
            craftoplus.place_switched_item(
                "craftoplus:bucket_empty", 
                itemstack, placer, pointed_thing
            );
        end,]]
    });
    
    -- MINECLONIA - BUCKET WATER
    core.override_item("mcl_buckets:bucket_water", {
        inventory_image="mcl_bucket.png^mcl_bucket_with_water.png",
    });
    
    -- MINECLONIA - BUCKET RIVER WATER
    core.override_item("mcl_buckets:bucket_river_water", {
        inventory_image="mcl_bucket.png^mcl_bucket_with_river_water.png",
    });
    
    -- MINECLONIA - BUCKET LAVA
    core.override_item("mcl_buckets:bucket_lava", {
        inventory_image="mcl_bucket.png^mcl_bucket_with_lava.png",
        --[[NEED_TO_FIX on_place = function(itemstack, placer, pointed_thing)
            craftoplus.place_switched_item(
                "craftoplus:bucket_with_lava", 
                itemstack, placer, pointed_thing
            );
        end,]]
    });
    
    -- MINECLONIA - BUCKET MILK
    core.override_item("mcl_mobitems:milk_bucket", {
        inventory_image="mcl_bucket.png^mcl_bucket_with_milk.png",
        groups = { food = 3, eatable = 4, can_eat_when_full = 1 },
        _mcl_saturation = 1.0,
    });
    
    -- MINECLONIA - BUCKET POWDER SNOW
    core.override_item("mcl_powder_snow:bucket_powder_snow", {
        inventory_image="mcl_bucket.png^mcl_bucket_with_snow.png",
    });
    
    -- MINECLONIA - PRESSURE PLATES
    for key, material in pairs({
        stone="mcl_core:cobble", polished_blackstone="mcl_blackstone:blackstone_polished",
        light="mcl_core:gold_ingot", heavy="mcl_core:iron_ingot",
    }) do
        core.clear_craft({output = "mcl_pressureplates:pressure_plate_"..key.."_off"});
        core.register_craft({
            output = "mcl_pressureplates:pressure_plate_"..key.."_off",
            recipe = { { material, material, "mcl_redstone:redstone" }, }
        });
    end;

    for wood, wood_id in pairs(craftoplus.woods) do
        core.clear_craft({output = "mcl_pressureplates:pressure_plate_"..wood.."_off"});
        core.register_craft({
            output = "mcl_pressureplates:pressure_plate_"..wood.."_off",
            recipe = { { "mcl_trees:wood_"..wood, "mcl_trees:wood_"..wood, "mcl_redstone:redstone" }, }
        });
    end;
    
    -- MINECLONIA - TRAPPED CHEST
    core.clear_craft({output = "mcl_chests:trapped_chest"});
    core.register_craft({
        output = "mcl_chests:trapped_chest",
        type = "shapeless",
        recipe = { "mcl_chests:chest", "mcl_redstone:redstone" }
    });
    
    -- MINECLONIA - LEVER
    
    local lever_recipe = {
        { "mcl_core:stick", "" },
        { "mcl_core:stone", "mcl_redstone:redstone" },
    };
    if core.registered_nodes["natural_habitat:stone_rubble"] then
        lever_recipe = {
            { "mcl_core:stick", "" },
            { "group:rubble", "mcl_redstone:redstone" },
        };
    end;
    core.clear_craft({output = "mcl_lever:lever_off"});
    core.register_craft({
        output = "mcl_lever:lever_off", 
        recipe = lever_recipe,
    });
    
    -- MINECLONIA - BUTTONS
    for wood, wood_id in pairs(craftoplus.woods) do
        core.clear_craft({output = "mcl_buttons:button_"..wood.."_off"});
    end

    core.register_craft({
        output = "mcl_buttons:button_oak_off",
        type = "shapeless",
        recipe = { "group:wood", "mcl_redstone:redstone" }
    })

    local function button_recipe_craft(itemstack, player, old_craft_grid, craft_inv)
        local wood = "oak";
        
        if itemstack:get_name() == "mcl_buttons:button_oak_off" then
            for i, item in pairs(old_craft_grid) do
                if (item:get_name() ~= "") then
                    if item:get_name():find("mcl_trees:wood_") then
                        wood = string.sub(item:get_name(), 16);
                    end
                end
            end
            
            return craftoplus.itemstack("mcl_buttons:button_"..wood.."_off", itemstack);
        else return end;
    end
    core.register_craft_predict(button_recipe_craft);
    core.register_on_craft(button_recipe_craft);

    local stone_recipe = { "mcl_core:stone", "mcl_redstone:redstone" };
    if core.registered_nodes["natural_habitat:stone_rubble"] then
        stone_recipe = { "natural_habitat:stone_rubble", "mcl_redstone:redstone" };
    end;
    core.clear_craft({output = "mcl_buttons:button_stone_off"});
    core.register_craft({
        output = "mcl_buttons:button_stone_off",
        type = "shapeless",
        recipe = stone_recipe,
    })

    core.clear_craft({output = "mcl_buttons:button_polished_blackstone_off"});
    core.register_craft({
        output = "mcl_buttons:button_polished_blackstone_off",
        type = "shapeless",
        recipe = { "mcl_blackstone:blackstone_polished", "mcl_redstone:redstone" }
    })
    
end;