-- SPLIT TEXT
function craftoplus.split(str, sep)
    return string.gmatch(str, "([^".. sep .."]+)");
end;

-- CAPITALIZE TEXT
function craftoplus.capitalize(str)
    return str:gsub("^%l", string.upper);
end;

-- TEXT TO NAME
function craftoplus.to_name(str, result)
    for part in craftoplus.split(str, "_") do
        if result then result = result.." "; else result = ""; end;
        result = result..part:gsub("^%l", string.upper);
    end;
    return result or "";
end