-- GET WARP MASK
function warp_portal.get_warp_mask(pos, yaw, placer)
    local function is(pos_node) return core.get_node(pos_node).name; end;
    
    if placer then yaw = placer:get_look_horizontal() end;
    yaw = yaw or 0;
    local left_dir = core.yaw_to_dir(yaw+math.pi/2);
    
    local left_pos = vector.add(pos, vector.round(left_dir));
    local right_pos = vector.subtract(pos, vector.round(left_dir));
    
    local m_pos = vector.add(pos, vector.new(0, 1, 0));
    local m_left = vector.add(left_pos, vector.new(0, 1, 0));
    local m_right = vector.add(right_pos, vector.new(0, 1, 0));
    
    local t_pos = vector.add(pos, vector.new(0, 2, 0));
    local t_left = vector.add(left_pos, vector.new(0, 2, 0));
    local t_right = vector.add(right_pos, vector.new(0, 2, 0));
    
    if (is(pos) == "air") and (is(left_pos) == "air") and (is(right_pos) == "air") and
       (is(m_pos) == "air") and (is(m_left) == "air") and (is(m_right) == "air") and
       (is(t_pos) == "air") and (is(t_left) == "air") and (is(t_right) == "air") then
            return true, m_pos, {
                left_pos, right_pos, m_left, m_right, 
                t_pos, t_left, t_right
            };
    end;
    
    return false, m_pos, {
        left_pos, right_pos, m_left, m_right, 
        t_pos, t_left, t_right
    };
end;

-- HIDEN PART NODE
core.register_node("warp_portal:hidden_part", {
    description = "Hidden Part",
    paramtype = "light",
    paramtype2 = "facedir",
    drawtype = "airlike",
    groups = { not_in_creative_inventory=1, },
    sunlight_propagates = true,
    walkable = false,
    pointable = false,
    diggable = false,
    buildable_to = false,
    floodable = false,
    drop = "",
    on_blast = function() end,
});