-- Detect creative mod --
local creative_mod = minetest.get_modpath("creative")
-- Cache creative mode setting as fallback if creative mod not present --
local creative_mode_cache = minetest.settings:get_bool("creative_mode")

-- Returns a on_secondary_use function that places the balloon block in the air -- 
local placeColour = function (colour)
	return function(itemstack, user, pointed_thing)
		-- Place node three blocks from the user in the air --
		local pos = user:getpos()
		local dir = user:get_look_dir()
		local balloonPlaceDistanceFromPlayer = 3
		local new_pos = {
			x = pos.x + (dir.x * balloonPlaceDistanceFromPlayer),
			y = pos.y + 1 + (dir.y * balloonPlaceDistanceFromPlayer),
			z = pos.z + (dir.z * balloonPlaceDistanceFromPlayer),
		}
		local getPos = minetest.get_node(new_pos)
		if getPos.name == "air" or
				getPos.name == "default:water_source" or
				getPos.name == "default:water_flowing" or
				getPos.name == "default:river_water_source" or
				getPos.name == "default:river_water_flowing" then
			local name = 'balloon_bop:'..colour
			minetest.set_node(new_pos, {name=name})
			local creative_enabled = (creative_mod and creative.is_enabled_for(user.get_player_name(user))) or creative_mode_cache
			if (not creative_enabled) then
				local stack = ItemStack(name)
				return ItemStack(name .. " " .. itemstack:get_count() - 1)
			end
		end
	end
end

local soundsConfig = function ()
	return {
	  footstep = {name = "balloon_bop_footstep", gain = 0.2},
	  dig = {name = "balloon_bop_footstep", gain = 0.3},
	  dug = {name = "default_dug_hard.1", gain = 0.3},
	  place = {name = "default_place_node_hard", gain = 1.0}
	}
end

-- Holds balloonblock functions and config --
local state = {
	placeRed = placeColour('red'),
	placeYellow = placeColour('yellow'),
	placeGreen = placeColour('green'),
	placeBlue = placeColour('blue'),
	placeBlack = placeColour('black'),
	placeWhite = placeColour('white'),
	placeOrange = placeColour('orange'),
	placePurple = placeColour('purple'),
	placeGrey = placeColour('grey'),
	placePink = placeColour('pink'),
	placeBrown = placeColour('brown'),
	placeGlowRed = placeColour('glowing_red'),
	placeGlowYellow = placeColour('glowing_yellow'),
	placeGlowGreen = placeColour('glowing_green'),
	placeGlowBlue = placeColour('glowing_blue'),
	placeGlowBlack = placeColour('glowing_black'),
	placeGlowWhite = placeColour('glowing_white'),
	placeGlowOrange = placeColour('glowing_orange'),
	placeGlowPurple = placeColour('glowing_purple'),
	placeGlowGrey = placeColour('glowing_grey'),
	placeGlowPink = placeColour('glowing_pink'),
	placeGlowBrown = placeColour('glowing_brown'),
	sounds = soundsConfig(),
	groups = {snappy=3, fall_damage_add_percent = -99, bouncy=70}
}
-- Normal balloon_bop --

minetest.register_node("balloon_bop:red", {
  description = "Red balloon",
  tiles = {"balloon_bop_red.png"},
	groups = state.groups,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeRed,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:red',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'dye:red', 'group:leaves'},
-- 		{'dye:red', 'group:leaves', 'dye:red'},
-- 	}
-- })

minetest.register_node("balloon_bop:yellow", {
	description = "Yellow balloon",
	tiles = {"balloon_bop_yellow.png"},
	groups = state.groups,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeYellow,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:yellow',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'dye:yellow', 'group:leaves'},
-- 		{'dye:yellow', 'group:leaves', 'dye:yellow'},
-- 	}
-- })

minetest.register_node("balloon_bop:green", {
  description = "Green balloon",
  tiles = {"balloon_bop_green.png"},
	groups = state.groups,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGreen,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:green',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'dye:green', 'group:leaves'},
-- 		{'dye:green', 'group:leaves', 'dye:green'},
-- 	}
-- })

minetest.register_node("balloon_bop:blue", {
  description = "Blue balloon",
  tiles = {"balloon_bop_blue.png"},
	groups = state.groups,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeBlue,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:blue',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'dye:blue', 'group:leaves'},
-- 		{'dye:blue', 'group:leaves', 'dye:blue'},
-- 	}
-- })

minetest.register_node("balloon_bop:black", {
  description = "Black balloon",
  tiles = {"balloon_bop_black.png"},
	groups = state.groups,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeBlack,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:black',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'dye:black', 'group:leaves'},
-- 		{'dye:black', 'group:leaves', 'dye:black'},
-- 	}
-- })

minetest.register_node("balloon_bop:white", {
  description = "White balloon",
  tiles = {"balloon_bop_white.png"},
	groups = state.groups,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeWhite,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:white',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'dye:white', 'group:leaves'},
-- 		{'dye:white', 'group:leaves', 'dye:white'},
-- 	}
-- })

minetest.register_node("balloon_bop:orange", {
  description = "Orange balloon",
  tiles = {"balloon_bop_orange.png"},
	groups = state.groups,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeOrange,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:orange',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'dye:orange', 'group:leaves'},
-- 		{'dye:orange', 'group:leaves', 'dye:orange'},
-- 	}
-- })

minetest.register_node("balloon_bop:purple", {
  description = "Purple balloon",
  tiles = {"balloon_bop_purple.png"},
	groups = state.groups,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placePurple,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:purple',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'dye:violet', 'group:leaves'},
-- 		{'dye:violet', 'group:leaves', 'dye:violet'},
-- 	}
-- })

minetest.register_node("balloon_bop:grey", {
  description = "Grey balloon",
  tiles = {"balloon_bop_grey.png"},
	groups = state.groups,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGrey,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:grey',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'dye:grey', 'group:leaves'},
-- 		{'dye:grey', 'group:leaves', 'dye:grey'},
-- 	}
-- })


minetest.register_node("balloon_bop:pink", {
  description = "Pink balloon",
  tiles = {"balloon_bop_pink.png"},
	groups = state.groups,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placePink,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:pink',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'dye:magenta', 'group:leaves'},
-- 		{'dye:magenta', 'group:leaves', 'dye:magenta'},
-- 	}
-- })


minetest.register_node("balloon_bop:brown", {
  description = "Brown balloon",
  tiles = {"balloon_bop_brown.png"},
	groups = state.groups,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeBrown,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:brown',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'dye:brown', 'group:leaves'},
-- 		{'dye:brown', 'group:leaves', 'dye:brown'},
-- 	}
-- })

-- -- Extra crafting for the normal balloon_bop--

-- minetest.register_craft({
-- 	output = 'balloon_bop:green',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:yellow', 'dye:blue' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:green',
-- 	type = 'shapeless',
-- 	recipe = { 'dye:yellow', 'balloon_bop:blue' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:orange',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:yellow', 'dye:red' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:orange',
-- 	type = 'shapeless',
-- 	recipe = { 'dye:yellow', 'balloon_bop:red' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:purple',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:red', 'dye:blue' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:purple',
-- 	type = 'shapeless',
-- 	recipe = { 'dye:red', 'balloon_bop:blue' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:grey',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:white', 'dye:black' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:grey',
-- 	type = 'shapeless',
-- 	recipe = { 'dye:white', 'balloon_bop:black' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:pink',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:white', 'dye:red' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:pink',
-- 	type = 'shapeless',
-- 	recipe = { 'dye:white', 'balloon_bop:red' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:brown',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:green', 'dye:red' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:brown',
-- 	type = 'shapeless',
-- 	recipe = { 'dye:green', 'balloon_bop:red' }
-- })

-- Glowing balloon_bop --

minetest.register_node("balloon_bop:glowing_red", {
  description = "Glowing red balloon",
  tiles = {"balloon_bop_red.png"},
	groups = state.groups,
	light_source = 30,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGlowRed,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_red',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'default:torch', 'group:leaves'},
-- 		{'dye:red', 'group:leaves', 'dye:red'},
-- 	}
-- })

minetest.register_node("balloon_bop:glowing_yellow", {
	description = "Glowing yellow balloon",
	tiles = {"balloon_bop_yellow.png"},
	groups = state.groups,
	light_source = 30,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGlowYellow,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_yellow',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'default:torch', 'group:leaves'},
-- 		{'dye:yellow', 'group:leaves', 'dye:yellow'},
-- 	}
-- })

minetest.register_node("balloon_bop:glowing_green", {
  description = "Glowing green balloon",
  tiles = {"balloon_bop_green.png"},
	groups = state.groups,
	light_source = 30,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGlowGreen,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_green',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'default:torch', 'group:leaves'},
-- 		{'dye:green', 'group:leaves', 'dye:green'},
-- 	}
-- })

minetest.register_node("balloon_bop:glowing_blue", {
  description = "Glowing blue balloon",
  tiles = {"balloon_bop_blue.png"},
	groups = state.groups,
	light_source = 30,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGlowBlue,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_blue',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'default:torch', 'group:leaves'},
-- 		{'dye:blue', 'group:leaves', 'dye:blue'},
-- 	}
-- })

minetest.register_node("balloon_bop:glowing_black", {
  description = "Glowing black balloon",
  tiles = {"balloon_bop_black.png"},
	groups = state.groups,
	light_source = 30,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGlowBlack,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_black',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'default:torch', 'group:leaves'},
-- 		{'dye:black', 'group:leaves', 'dye:black'},
-- 	}
-- })

minetest.register_node("balloon_bop:glowing_white", {
  description = "Glowing white balloon",
  tiles = {"balloon_bop_white.png"},
	groups = state.groups,
	light_source = 30,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGlowWhite,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_white',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'default:torch', 'group:leaves'},
-- 		{'dye:white', 'group:leaves', 'dye:white'},
-- 	}
-- })

minetest.register_node("balloon_bop:glowing_orange", {
  description = "Glowing orange balloon",
  tiles = {"balloon_bop_orange.png"},
	groups = state.groups,
	light_source = 30,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGlowOrange,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_orange',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'default:torch', 'group:leaves'},
-- 		{'dye:orange', 'group:leaves', 'dye:orange'},
-- 	}
-- })

minetest.register_node("balloon_bop:glowing_purple", {
  description = "Glowing purple balloon",
  tiles = {"balloon_bop_purple.png"},
	groups = state.groups,
	light_source = 30,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGlowPurple,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_purple',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'default:torch', 'group:leaves'},
-- 		{'dye:violet', 'group:leaves', 'dye:violet'},
-- 	}
-- })

minetest.register_node("balloon_bop:glowing_grey", {
  description = "Glowing grey balloon",
  tiles = {"balloon_bop_grey.png"},
	groups = state.groups,
	light_source = 30,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGlowGrey,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_grey',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'default:torch', 'group:leaves'},
-- 		{'dye:grey', 'group:leaves', 'dye:grey'},
-- 	}
-- })


minetest.register_node("balloon_bop:glowing_pink", {
  description = "Glowing pink balloon",
  tiles = {"balloon_bop_pink.png"},
	groups = state.groups,
	light_source = 30,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGlowPink,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_pink',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'default:torch', 'group:leaves'},
-- 		{'dye:magenta', 'group:leaves', 'dye:magenta'},
-- 	}
-- })


minetest.register_node("balloon_bop:glowing_brown", {
  description = "Glowing brown balloon",
  tiles = {"balloon_bop_brown.png"},
	groups = state.groups,
	light_source = 30,
	paramtype = "light",
	sunlight_propagates = true,
	on_secondary_use = state.placeGlowBrown,
	sounds = state.sounds
})

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_brown',
-- 	recipe = {
-- 		{'group:leaves', 'group:leaves', 'group:leaves'},
-- 		{'group:leaves', 'default:torch', 'group:leaves'},
-- 		{'dye:brown', 'group:leaves', 'dye:brown'},
-- 	}
-- })

-- -- Extra crafting for the glowing balloons--

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_red',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:red', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_yellow',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:yellow', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_green',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:green', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_blue',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:blue', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_black',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:black', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_white',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:white', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_orange',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:orange', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_purple',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:purple', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_pink',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:pink', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_grey',
-- 	type = 'shapeless',
-- 	recipe = { 'default:torch', 'balloon_bop:grey' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_brown',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:brown', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_green',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:glowing_yellow', 'dye:blue' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_green',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:glowing_blue', 'dye:yellow' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_orange',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:glowing_red', 'dye:yellow' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_orange',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:glowing_yellow', 'dye:red' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_purple',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:glowing_blue', 'dye:red' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_purple',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:glowing_red', 'dye:blue' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_pink',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:glowing_white', 'dye:red' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_pink',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:glowing_red', 'dye:white' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_grey',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:glowing_white', 'dye:black' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_grey',
-- 	type = 'shapeless',
-- 	recipe = { 'dye:white', 'balloon_bop:glowing_black' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_brown',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:glowing_red', 'dye:green' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_brown',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:glowing_green', 'dye:red' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_green',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:yellow', 'dye:blue', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_green',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:blue', 'dye:yellow', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_orange',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:red', 'dye:yellow', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_orange',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:yellow', 'dye:red', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_purple',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:blue', 'dye:red', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_purple',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:red', 'dye:blue', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_pink',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:white', 'dye:red', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_pink',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:red', 'dye:white', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_grey',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:white', 'dye:black', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_grey',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:black', 'dye:white', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_brown',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:red', 'dye:green', 'default:torch' }
-- })

-- minetest.register_craft({
-- 	output = 'balloon_bop:glowing_brown',
-- 	type = 'shapeless',
-- 	recipe = { 'balloon_bop:green', 'dye:red', 'default:torch' }
-- })
