local S = core.get_translator("balloon_bop")

local cmd = chatcmdbuilder.register("bbop", {
    description = "mod management",
    privs = { arenalib_admin = true }}
)

cmd:sub("scores :arena", function(sender, ar_name)
    if balloon_bop.scores[ar_name] then
        core.show_formspec(sender, "bb_scores", balloon_bop.get_leader_form(ar_name, sender))
    else
        core.chat_send_player(sender, S("[!] No data for that arena or that arena does not exist!"))
    end
end)

cmd:sub("resetscore :playername:word confirm", function(sender, p_name)
    for _, arena in ipairs(arena_lib.mods.balloon_bop.arenas) do
        balloon_bop.scores[arena.name][p_name] = nil
    end

    core.chat_send_player(sender, S("Scores of player @1 successfully reset", p_name))
end)

core.register_chatcommand("balloonbopscores", {
    params = "<"..S("arena name")..">",  -- Short parameter description

    description = S("Deprecated, use `/bbop scores <arena_name>` instead"),  -- Full description

    func = function(name, param)
            core.chat_send_player(name, S("Deprecated, use `/bbop scores <arena_name>` instead"))
        end,
})
