

minetest.register_tool("bb_nodes:breaker", {
    description = "Node Breaker",
    inventory_image = "bb_nodes_breaker.png",
    tool_capabilities = {
        full_punch_interval = 1.5,
        max_drop_level = 1,
        groupcaps = {
            cracky = {
                maxlevel = 3,
                uses = 2000,
                times = { [1]=0.20, [2]=0.20, [3]=0.20 }
            },
        },
    },
})




minetest.register_node("bb_nodes:floor", {
    description = "Floor",
    paramtype = "light",
    tiles = {"bb_nodes_floor.png"},
    groups = {cracky = 3, floor = 1},
}) 


minetest.register_node("bb_nodes:floor_with_arrow", {
    description = "Floor Arrow\n Pushes bombs in this direction",
    tiles = {"bb_nodes_floor_with_arrow.png","bb_nodes_floor.png"},
    groups = {cracky = 3, floor = 1, arrow = 1},
    paramtype = "light",
    paramtype2 = "facedir",
}) 


minetest.register_node("bb_nodes:floor_with_mortar", {
    description = "Floor Mortar\n Collects and randomly throws bombs",
    tiles = {"bb_nodes_floor_with_mortar.png","bb_nodes_floor.png"},
    groups = {cracky = 3, floor = 1, mortar = 1},
    paramtype = "light",
    paramtype2 = "facedir",
}) 


minetest.register_node("bb_nodes:brick", {
    description = "Removable Wall",
    tiles = {"bb_nodes_brick.png^[transformFX","bb_nodes_brick.png"},
    paramtype = "light",
    groups = {cracky = 3,penetrable = 1,removable = 1,powerup = 1},
}) 


minetest.register_node("bb_nodes:crate", {
    description = "Removable Crate",
    tiles = {"bb_nodes_crate.png"},
    paramtype = "light",
    groups = {cracky = 3,penetrable = 1,removable = 1,powerup = 2},
}) 


minetest.register_node("bb_nodes:ice", {
    description = "Slippery Ice",
    tiles = {"bb_nodes_ice.png"},
    paramtype = "light",
    groups = {cracky = 3, slippery = 9, floor = 1},
}) 


minetest.register_node("bb_nodes:wall", {
    description = "Solid Wall",
    tiles = {"bb_nodes_wall.png"},
    paramtype = "light",
    groups = {cracky = 3,penetrable = 1,},
}) 